<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use App\SmLanguagePhrase;

class CreateSmLanguagePhrasesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sm_language_phrases', function (Blueprint $table) {
            $table->collation = 'utf8_general_ci';
            $table->charset = 'utf8';
            $table->increments('id');
            $table->text('modules')->nullable();
            $table->text('default_phrases')->nullable();
            $table->text('en')->nullable();
            $table->text('es')->nullable();
            $table->text('bn')->nullable();
            $table->text('fr')->nullable();
            $table->tinyInteger('active_status')->default('1');
            $table->timestamps();
        });

        $d = [
            [0, 'dashboard', 'Dashboard', 'Tablero', 'ড্যাশবোর্ড', 'Tableau de bord'],
            [0, 'your', 'Your', 'Your', 'তোমার', 'Your'],
            [0, 'read_more', 'Read More', 'Read More', 'আরও পড়ুন', 'Read More'],
            [0, 'add_to_do', 'Add To Do', 'Add To Do', 'করতে যোগ করুন', 'Add To Do'],
            [0, 'welcome', 'Welcome', 'Bienvenido', 'স্বাগত', 'Bienvenue'],
            [0, 'student', 'Student', 'Estudiante', 'ছাত্র', 'Étudiant'],
            [0, 'total', 'Total', 'Total', 'মোট', 'Total'],
            [0, 'template', 'Template', 'Template', 'টেমপ্লেট', 'Template'],
            [0, 'early', 'Early', 'Early', 'তাড়াতাড়ি', 'Early'],
            [0, 'cheque_bounce', 'Cheque Bounce', 'Cheque Bounce', 'বাউন্স পরীক্ষা করুন', 'Cheque Bounce'],
            [0, 'checkout', 'Checkout', 'Checkout', 'চেকআউট', 'Checkout'],
            [0, 'check', 'Check', 'Check', 'চেক', 'Check'],
            [0, 'credentials', 'Credentials', 'Credentials', 'শংসাপত্রাদি', 'Credentials'],
            [0, 'birthday', 'Birthday', 'Birthday', 'জন্মদিন', 'Birthday'],
            [0, 'application', 'Application', 'Application', 'প্রয়োগ', 'Application'],
            [0, 'student_admitted_message', 'Student Admitted Message', 'Student Admitted Message', 'ছাত্র ভর্তি বার্তা', 'Student Admitted Message'],
            [0, 'student_admission_progress', 'Student Admission In Progress', 'Student Admission In Progress', 'শিক্ষার্থী ভর্তি চলছে', 'Student Admission In Progress'],
            [0, 'teachers', 'Teachers', 'Maestros', 'শিক্ষক', 'Enseignants'],
            [0, 'parents', 'Parents', 'Los padres', 'মাতাপিতা', 'Parents'],
            [0, 'staffs', 'Staffs', 'Personal', 'কর্মীরা', 'Le personnel'],
            [0, 'income_and_expenses_for', 'Income and Expenses for', 'Ingresos y gastos para', 'আয় এবং ব্যয়ের জন্য', 'Revenus et dépenses pour'],
            [0, 'total_income', 'Total Income', 'Ingresos totales', 'মোট আয়', 'Revenu total'],
            [0, 'total_expenses', 'Total Expenses', 'Gastos totales', 'মোট খরচ', 'Dépenses totales'],
            [0, 'total_profit', 'Total Profit', 'Beneficio total', 'সমস্ত লাভ', 'Bénéfice total'],
            [0, 'total_revenue', 'Total Revenue', 'Los ingresos totales', 'মোট রাজস্ব', 'Revenu total'],
            [0, 'title', 'Title', 'Título', 'শিরোনাম', 'Titre'],
            [0, 'message', 'Message', 'Mensaje', 'বার্তা', 'Message'],
            [0, 'actions', 'Actions', 'Comportamiento', 'ক্রিয়াকলাপ', 'actes'],
            [0, 'calendar', 'Calendar', 'Calendario', 'পাঁজি', 'Calendrier'],
            [0, 'view', 'View', 'Ver', 'দৃশ্য', 'Vue'],
            [0, 'to_do_list', 'To Do List', 'Lista de quehaceres', 'তালিকা তৈরি', 'Liste de choses à faire'],
            [0, 'add', 'Add', 'Añadir', 'যোগ', 'Ajouter'],
            [0, 'edit', 'Edit', 'Editar', 'সম্পাদন করা', 'modifier'],
            [0, 'no_do_lists_assigned_yet', 'No Do Lists Assigned Yet', 'No hay listas asignadas aún', 'এখনও কোনও তালিকা তালিকাভুক্ত করা হয়নি', 'Aucune liste assignée pour linstant'],
            [0, 'theme', 'Theme', 'Theme', 'বিষয়', 'Theme'],
            [0, 'time_zone', 'Time Zone', 'Time Zone', 'সময় অঞ্চল', 'Time Zone'],
            [0, 'mail', 'Mail', 'Mail', 'মেল', 'Mail'],
            [0, 'host', 'Host', 'Host', 'নিমন্ত্রণকর্তা', 'Host'],
            [0, 'encryption', 'Encryption', 'Encryption', 'জোড়া লাগানো', 'Encryption'],
            [0, 'login', 'Login', 'Login', 'প্রবেশ করুন', 'Login'],
            [0, 'enter', 'Enter', 'Enter', 'প্রবেশ করান', 'Enter'],
            [0, 'remember_me', 'Remember Me', 'Remember Me', 'আমাকে মনে কর', 'Remember Me'],
            [0, 'forget', 'Forget', 'Forget', 'ভুলে যান', 'Forget'],
            [0, 'current_month', 'Current Month', 'Current Month', 'বর্তমান মাস', 'Current Month'],
            [0, 'keyword', 'Keyword', 'Keyword', 'কী খুঁজতে হবে', 'Keyword'],
            [0, 'manage', 'Manage', 'manage', 'পরিচালনা করা', 'manage'],
            [0, 'manager', 'Manager', 'manager', 'পরিচালনা ', 'Manager'],
            [0, 'next', 'Next', 'Next', 'পরবর্তী', 'Next'],
            
            [0, 'child', 'Child', 'Child', 'শিশু', 'Child'],
            [0, 'running', 'Running', 'Running', 'চলমান', 'Running'],
            [0, 'select_academic_year', 'Select Academic Year', 'Select Academic Year', 'একাডেমিক বছর নির্বাচন করুন', 'Select Academic Year'],
            [0, 'PDF', 'PDF', 'PDF', 'পিডিএফ', 'PDF'],
            [0, 'biometrics', 'Biometrics', 'Biometrics', 'বায়োমেট্রিক্স', 'Biometrics'],
            [1, 'admin_section', 'Admin Section', 'Sección de Administración', 'প্রশাসন বিভাগ', 'Section Admin'],
            [1, 'admission_query', 'Admission Query', 'Consulta de Admisión', 'ভর্তি প্রশ্ন', 'Requête dadmission'],
            [1, 'select_criteria', 'Select Criteria', 'Seleccione los criterios', 'মানদণ্ড নির্বাচন করুন', 'Sélectionner des critères'],
            [1, 'date_from', 'Date From', 'Fecha de', 'তারিখ থেকে', 'Dater de'],
            [1, 'date_to', 'Date To', 'Fecha para', 'তারিখ', 'Date à'],
            [1, 'select_source', 'Select Source', 'Seleccione Fuente', 'উত্স নির্বাচন করুন', 'Sélectionnez la source'],
            [1, 'select_status', 'Select status', 'Seleccionar estado', 'স্থিতি নির্বাচন করুন', 'Sélectionnez le statut'],
            [1, 'Status', 'Status', 'Estado', 'অবস্থা', 'Statut'],
            [1, 'active', 'Active', 'Activo', 'সক্রিয়', 'actif'],
            [1, 'inactive', 'Inactive', 'Inactivo', 'নিষ্ক্রিয়', 'Inactif'],
            [1, 'search', 'Search', 'Buscar', 'অনুসন্ধান করুন', 'Chercher'],
            [1, 'no_data_available_in_table', 'No data available in table', 'No data available in table', 'সারণীতে কোনও ডেটা উপলব্ধ নেই', 'No data available in table'],
            [1, 'entries', 'Entries', 'Entries', 'এন্ট্রি', 'Entries'],
            [1, 'query_list', 'Query List', 'Lista de consultas', 'অনুসন্ধানের তালিকা', 'Liste de requêtes'],
            [1, 'grid_gap', 'Grid Gap', 'krada breĉo', 'গ্রিড ফাঁক', 'écart de grille'],
            [1, 'name', 'Name', 'Nombre', 'নাম', 'prénom'],
            [1, 'phone', 'Phone', 'Teléfono', 'ফোন', 'Téléphone'],
            [1, 'source', 'Source', 'Fuente', 'সূত্র', 'La source'],
            [1, 'email', 'Email', 'Email', 'ইমেইল', 'Email'],
            
            [1, 'query_date', 'Query Date', 'Fecha de consulta', 'অনুসন্ধানের তারিখ', 'Date de la requête'],
            [1, 'last_follow_up_date', 'last follow up date', 'última fecha de seguimiento', 'শেষ অনুসরণ তারিখ', 'dernière date de suivi'],
            [1, 'next_follow_up_date', 'next follow up date', 'siguiente fecha de seguimiento', 'পরবর্তী অনুসরণ তারিখ', 'prochaine date de suivi'],
            [1, 'select', 'Select', 'Seleccionar', 'নির্বাচন করা', 'Sélectionner'],
            [1, 'add_query', 'Add Query', 'Añadir consulta', 'অনুসন্ধান যোগ করুন', 'Ajouter une requête'],
            [1, 'delete', 'Delete', 'Borrar', 'মুছে ফেলা', 'Effacer'],
            [1, 'delete_admission_query', 'Delete Admission Query', 'Eliminar consulta de admisión', 'ভর্তি প্রশ্ন মুছুন', 'Supprimer la requête dadmission'],
            [1, 'are_you_sure_to_delete', 'Are you sure to delete this item?', '¿Estás seguro de eliminar este elemento?', 'আপনি কি এই আইটেমটি মুছে ফেলার বিষয়ে নিশ্চিত?', 'Êtes-vous sûr de vouloir supprimer cet article?'],
            [1, 'are_you_sure_to_disable', 'Are you sure to disable this item?', '¿Estás seguro de eliminar este elemento?', 'আপনি কি এই আইটেমটি মুছে ফেলার বিষয়ে নিশ্চিত?', 'Êtes-vous sûr de vouloir supprimer cet article?'],
            [1, 'are_you_sure_to_enable', 'Are you sure to enable this item?', '¿Estás seguro de eliminar este elemento?', 'আপনি কি এই আইটেমটি মুছে ফেলার বিষয়ে নিশ্চিত?', 'Êtes-vous sûr de vouloir supprimer cet article?'],
            [1, 'cancel', 'Cancel', 'Cancelar', 'বাতিল', 'Annuler'],
            [1, 'admission_enquiry', 'Admission Enquiry', 'Consulta de Admisión', 'ভর্তি তদন্ত', 'Enquête dadmission'],
            [1, 'address', 'Address', 'Dirección', 'ঠিকানা', 'Adresse'],
            [1, 'description', 'Description', 'Descripción', 'বিবরণ', 'La description'],
            [1, 'date', 'Date', 'Fecha', 'তারিখ', 'Rendez-vous amoureux'],
            [1, 'expired', 'Expired', 'Expired', 'মেয়াদোত্তীর্ণ', 'Expired'],
            [1, 'assigned', 'Assigned', 'Asignado', 'বরাদ্দ', 'Attribué'],
            [1, 'reference', 'Reference', 'Referencia', 'উল্লেখ', 'Référence'],
            [1, 'number_of_child', 'Number of child', 'Numero de niño', 'সন্তানের সংখ্যা', 'Nombre denfant'],
            [1, 'save', 'Save', 'Salvar', 'সংরক্ষণ', 'sauvegarder'],
            [1, 'visitor_book', 'Visitor Book', 'Libro de visitas', 'ভিজিটর বুক', 'Livre de visites'],
            [1, 'visitor', 'Visitor', 'Visitante', 'দর্শনার্থী', 'Visiteur'],
            [1, 'purpose', 'Purpose', 'Propósito', 'উদ্দেশ্য', 'Objectif'],
            [1, 'id', 'Id', 'CARNÉ DE IDENTIDAd', 'আইডি', 'Id'],
            [1, 'no_of_person', 'No. of Person', 'No. de persona', 'ব্যক্তির সংখ্যা', 'No. de personne'],
            [1, 'in_time', 'In Time', 'A tiempo', 'সময়', 'À lheure'],
            [1, 'out_time', 'Out time', 'Fuera de tiempo', 'সময় শেষ', 'Temps de sortie'],
            [1, 'out_of', 'Out Of', 'Out Of', 'এর বাইরে', 'Out Of'],
            [1, 'browse', 'browse', 'vistazo', 'ব্রাউজ', 'Feuilleter'],
            [1, 'update', 'Update', 'Actualizar', 'হালনাগাদ', 'Mettre à jour'],
            [1, 'visitor_list', 'Visitor List', 'Lista de visitantes', 'দর্শনার্থীর তালিকা', 'Liste de visiteurs'],
            [1, 'download', 'Download', 'Descargar', 'ডাউনলোড', 'Télécharger'],
            [1, 'complaint', 'Complaint', 'Queja', 'অভিযোগ', 'Plainte'],
            [1, 'by', 'By', 'Por', 'দ্বারা', 'Par'],
            [1, 'type', 'Type', 'Tipo', 'আদর্শ', 'Type'],
            [1, 'taken', 'Taken', 'Tomado', 'ধরা', 'Pris'],
            [1, 'list', 'List', 'Lista', 'তালিকা', 'liste'],
            [1, 'postal_receive', 'Postal Receive', 'Recibir Postal', 'ডাক প্রাপ্তি', 'Réception postale'],
            [1, 'from_title', 'From Title', 'Del título', 'শিরোনাম থেকে', 'De titre'],
            [1, 'no', 'No', 'No', 'না', 'Non'],
            [1, 'note', 'Note', 'Nota', 'বিঃদ্রঃ', 'Remarque'],
            [1, 'to_title', 'To Title', 'Al título', 'শিরোনাম', 'Au titre'],
            [1, 'postal_dispatch', 'Postal Dispatch', 'Despacho Postal', 'ডাক প্রেরণ', 'Envoi postal'],
            [1, 'phone_call_log', 'Phone Call Log', 'Registro de llamadas telefónicas', 'ফোন কল লগ', 'Journal des appels téléphoniques'],
            [1, 'phone_call', 'Phone Call', 'Llamada telefónica', 'ফোন কল', 'Appel téléphonique'],
            [1, 'follow_up_date', 'Follow Up Date', 'Fecha de seguimiento', 'অনুসরণ তারিখ', 'Date de suivi'],
            [1, 'call_duration', 'Call Duration', 'Duración de la llamada', 'কল সময়কাল', 'Durée dappel'],
            [1, 'incoming', 'Incoming', 'Entrante', 'ইনকামিং', 'Entrant'],
            [1, 'outgoing', 'Outgoing', 'Saliente', 'বিদায়ী', 'Sortant'],
            [1, 'call', 'Call', 'Llamada', 'কল', 'Appel'],
            [1, 'admin_setup', 'Admin Setup', 'Configuración de administrador', 'অ্যাডমিন সেটআপ', 'Configuration de ladministrateur'],
            [1, 'setup_admin', 'Admin Setup', 'Configuración de administrador', 'অ্যাডমিন সেটআপ', 'Configuration de ladministrateur'],

            [1, 'student_certificate', 'Student Certificate', 'Certificado de estudiante', 'ছাত্র শংসাপত্র', 'Certificat détudiant'],
            [1, 'certificate', 'Certificate', 'Certificado', 'সনদপত্র', 'Certificat'],
            [1, 'header_left_text', 'Header left text', 'Encabezado texto a la izquierda', 'শিরোনাম বাম পাঠ্য', 'En-tête gauche du texte'],
            [1, 'body', 'Body', 'Cuerpo', 'শরীর', 'Corps'],
            [1, 'footer_left_text', 'Footer left text', 'Pie de página texto a la izquierda', 'পাদচরণ বাম পাঠ্য', 'Footer left text'],
            [1, 'footer_center_text', 'Footer Center text', 'Texto del centro de pie de página', 'পাদচরণ কেন্দ্র পাঠ্য', 'Footer Center text'],
            [1, 'footer_right_text', 'Footer Right text', 'Pie derecho texto', 'পাদলেখ ডান পাঠ্য', 'Footer Right text'],
            [1, 'student_photo', 'Student Photo', 'Foto de estudiante', 'ছাত্রের ছবি', 'Photo étudiante'],
            [1, 'yes', 'Yes', 'sí', 'হ্যাঁ', 'Oui'],
            [1, 'none', 'No', 'No', 'না', 'Non'],
            [1, 'background_image', 'Background Image', 'Imagen de fondo', 'পটভূমি চিত্র', 'Image de fond'],
            [1, 'generate_certificate', 'Generate Certificate', 'Generar certificado', 'শংসাপত্র তৈরি করুন', 'Générer un certificat'],
            [1, 'select_section', 'Select section', 'Seleccione la sección', 'বিভাগ নির্বাচন করুন', 'Sélectionnez une section'],
            [1, 'generate', 'Generate', 'Generar', 'জেনারেট করুন', 'produire'],
            [1, 'admission', 'Admission', 'Admisión', 'স্বীকারোক্তি', 'Admission'],
            [1, 'class_Sec', 'Class (Sec.)', 'Clase (Sec.)', 'ক্লাস (সেকেন্ড)', 'Classe (Sec.)'],
            [1, 'father', 'Father', 'Padre', 'পিতা', 'Père'],
            [1, 'date_of_birth', 'Date Of Birth', 'Fecha de nacimiento', 'জন্ম তারিখ', 'Date de naissance'],
            [1, 'gender', 'Gender', 'Género', 'লিঙ্গ', 'Le sexe'],
            [1, 'mobile', 'Mobile', 'Móvil', 'মুঠোফোন', 'Mobile'],
            [1, 'student_id_card', 'Student ID Card', 'Credencial de estudiante', 'শিক্ষার্থী আইডি কার্ড', 'Carde didentité détudiant'],
            [1, 'id_card_title', 'ID Card Title', 'Título de la tarjeta de identificación', 'আইডি কার্ডের শিরোনাম', 'Titre de la carte didentité'],
            [1, 'number', 'Number', 'Número', 'সংখ্যা', 'Nombre'],
            [1, 'mother', 'Mother', 'Madre', 'মা', 'Mère'],
            [1, 'blood_group', 'Blood Group', 'Grupo sanguíneo', 'রক্তের গ্রুপ', 'Groupe sanguin'],
            [1, 'id_card', 'ID Card', 'Tarjeta de identificación', 'পরিচয় পত্র', 'Carte didentité'],
            [1, 'generate_id_card', 'Generate ID Card', 'Generar tarjeta de identificación', 'আইডি কার্ড তৈরি করুন', 'Générer une carte didentité'],
            [1, 'all', 'All', 'Todos', 'সব', 'Tout'],
            [1, 'relation_with_guardian', 'Relation with Guardian', 'Relación con Guardian', 'অভিভাবকের সাথে সম্পর্ক', 'Relation avec le gardien'],
            [1, 'admin', 'Admin', 'Administración', 'অ্যাডমিন', 'Admin'],
            [1, 'follow_up', 'Follow up', 'Seguir', 'অনুসরণ করুন', 'Suivre'],
            [1, 'follow_up_admission_query', 'Follow Up Admission Query', 'Consulta de seguimiento de admisión', 'ভর্তি প্রশ্ন অনুসরণ করুন', 'Requête dadmission de suivi'],
            [1, 'response', 'Response', 'Respuesta', 'প্রতিক্রিয়া', 'Réponse'],
            [1, 'follow_up_list', 'Follow Up List', 'Lista de seguimiento', 'ফলো আপ তালিকা', 'Liste de suivi'],
            [1, 'query_by', 'Query By', 'Consulta por', 'অনুসন্ধান দ্বারা', 'Requête par'],
            [1, 'delete_follow_up_query', 'Delete Follow up query', 'Eliminar consulta de seguimiento', 'ফলো আপ কোয়েরি মুছুন', 'Supprimer la requête de suivi'],
            [1, 'certificate_body_len', 'Max Character lenght 500', 'Longitud máxima de caracteres 500', 'সর্বোচ্চ অক্ষর 500 দৈর্ঘ্য 500', 'Longueur maximum 500 caractères'],
            [1, 'class_section', 'Class (Sec.)', 'Clase (Sec.)', 'ক্লাস (সেকেন্ড)', 'Classe (Sec.)'],
            [1, 'are_you_sure_to_remove', 'Are you sure to remove this item?', '¿Estás seguro de eliminar este elemento?', 'আপনি কি এই আইটেমটি সরানোর বিষয়ে নিশ্চিত?', 'Êtes-vous sûr de vouloir supprimer cet article?'],
            [1, 'admission_no', 'Admission No', 'Admission No', 'ভর্তি নং', 'Admission No'],
            [1, 'grid_gap', 'Grid Gap', 'Grid Gap', 'গ্রিড ফাঁক', 'Grid Gap'],
            [1, 'no', 'No', 'No', 'না', 'No'],
            [1, 'fill_marks', 'Fill Marks', 'Fill Marks', 'চিহ্ন পূরণ করুন', 'Fill Marks'],
            [1, 'main', 'Main', 'Main', 'প্রধান', 'Main'],
            [1, 'duration', 'Duration', 'Duration', 'স্থিতিকাল', 'Duration'],
            [1, 'approve', 'Approve', 'Approve', 'অনুমোদন করা', 'Approve'],
            [1, 'user_name', 'User Name', 'User Name', 'ব্যবহারকারীর নাম', 'User Name'],
            [1, 'rate', 'Rate', 'Rate', 'হার', 'Rate'],
            [1, 'hourly_rate', 'Hourly Rate', 'Hourly Rate', 'প্রতি ঘণ্টার মূল্য', 'Hourly Rate'],
            [1, 'add_new_staff', 'Add New Staff', 'Add New Staff', 'নতুন স্টাফ যোগ করুন', 'Add New Staff'],
            [1, 'first_name', 'First Name', 'First Name', 'নামের প্রথম অংশ', 'First Name'],
            [1, 'last_name', 'Last Name', 'Last Name', 'নামের শেষাংশ', 'Last Name'],
            [1, 'married', 'Married', 'Married', 'বিবাহিত', 'Married'],
            [1, 'unmarried', 'Unmarried', 'Unmarried', 'অবিবাহিত', 'Unmarried'],
            [1, 'marital_status', 'Marital Status', 'Marital Status', 'বৈবাহিক অবস্থা', 'Marital Status'],
            [1, 'driving_license', 'Driving License', 'Driving License', 'ড্রাইভিং লাইসেন্স', 'Driving License'],
            [1, 'contract', 'Contract', 'Contract', 'চুক্তি', 'Contract'],
            [1, 'crop', 'Crop', 'Crop', 'ফসল', 'Crop'],
            [1, 'crop_image_and_upload', 'Crop Image And Upload', 'Crop Image And Upload', 'চিত্র ক্রপ করুন এবং আপলোড করুন', 'Crop Image And Upload'],
            [1, 'staff_ID', 'Staff ID', 'Staff ID', 'স্টাফ আইডি', 'Staff ID'],
            [1, 'for_the_period_of', 'for the period of', 'for the period of', 'সময়ের জন্য', 'for the period of'],
            [1, 'evaluated_by', 'Evaluated By', 'Evaluated By', 'মূল্যায়ন দ্বারা', 'Evaluated By'],
            [1, 'summary', 'Summary', 'Summary', 'সারসংক্ষেপ', 'Summary'],
            [1, 'good', 'Good', 'Good', 'ভাল', 'Good'],
            [1, 'not', 'Not', 'Not', 'না', 'Not'],
            [1, 'comments', 'Comments', 'Comments', 'মন্তব্য', 'Comments'],
            [1, 'roll_number', 'Roll Number', 'Roll Number', 'রোল নাম্বার', 'Roll Number'],
            [1, 'cash', 'Cash', 'Cash', 'নগদ', 'Cash'],
            [1, 'cheque', 'Cheque', 'Cheque', 'চেক', 'Cheque'],
            [1, 'dd', 'DD', 'DD', 'ডিডি', 'DD'],
            [1, 'please_give_the_all_information_properly', 'Please Give the All Information Properly. We can not Save any of Your Data. Your Safety is our First Priority', 'Please Give the All Information Properly. We can not Save any of Your Data. Your Safety is our First Priority', 'দয়া করে সমস্ত তথ্য সঠিকভাবে দিন। আমরা আপনার কোনও ডেটা সংরক্ষণ করতে পারি না। আপনার সুরক্ষা আমাদের প্রথম অগ্রাধিকার', 'Please Give the All Information Properly. We can not Save any of Your Data. Your Safety is our First Priority'],
            [1, 'expiration', 'Expiration', 'Expiration', 'শ্বাসত্যাগ', 'Expiration'],
            [1, 'cvc', 'CVC', 'CVC', 'সিভিসি', 'CVC'],
            [1, 'card_number', 'Card Number', 'Card Number', 'কার্ড নম্বর', 'Card Number'],
            [1, 'name_on_card', 'Name on Card', 'Name on Card', 'কার্ডের ওপর নাম', 'Name on Card'],
            [1, 'vai_card', 'vai Card', 'vai Card', 'ভাই কার্ড', 'vai Card'],
            [1, 'pay_with', 'Pay with', 'Pay with', 'সঙ্গে দিতে', 'Pay with'],
            [1, 'pay', 'Pay', 'Pay', 'পে', 'Pay'],
            [1, 'expiration_month', 'Expiration Month', 'Expiration Month', 'মেয়াদ মাস', 'Expiration Month'],
            [1, 'expiration_year', 'Expiration Year', 'Expiration Year', 'মেয়াদোত্তীর্ণ বছর', 'Expiration Year'],
            [1, 'fees', 'Fees', 'Fees', 'ফি', 'Fees'],
            [1, 'all_fees', 'All Fees', 'All Fees', 'সমস্ত ফি', 'All Fees'],
            [1, 'online', 'Online', 'Online', 'অনলাইন', 'Online'],
            [1, 'assign_exam_room', 'Assign Exam Room', 'Assign Exam Room', 'পরীক্ষার ঘর বরাদ্দ করুন', 'Assign Exam Room'],
            [1, 'level', 'Level', 'Level', 'উচ্চতা', 'Level'],
            [1, 'question_level', 'Question Level', 'Question Level', 'প্রশ্ন স্তর', 'Question Level'],
            [1, 'update_online_exam_question', 'Update Online Exam Question', 'Update Online Exam Question', 'অনলাইন পরীক্ষার প্রশ্ন আপডেট করুন', 'Update Online Exam Question'],
            [1, 'number_options', 'Number Options', 'Number Options', 'সংখ্যা বিকল্প', 'Number Options'],
            [1, 'currect_answer', 'Currect Answer', 'Currect Answer', 'কারেন্ট উত্তর', 'Currect Answer'],
            [1, 'currect', 'Currect', 'Currect', 'কারেন্ট', 'Currect'],
            [1, 'exam_has_to_be_submitted_within', 'Exam Has To Be Submitted Within', 'Exam Has To Be Submitted Within', 'পরীক্ষার মধ্যে জমা দিতে হবে', 'Exam Has To Be Submitted Within'],
            [1, 'is_present', 'Is Present', 'Is Present', 'উপস্থিত', 'Is Present'],
            [1, 'roll_no', 'Roll No', 'Roll No', 'ক্রমিক নাম্বার', 'Roll No'],
            [1, 'button_url', 'Button Url', 'Button Url', 'বাটন ইউআর', 'Button Url'],
            [1, 'button_text', 'Button Text', 'Button Text', 'বোতাম পাঠ্য', 'Button Text'],
            [1, 'course', 'Course', 'Course', 'পথ', 'Course'],
            [1, 'update_course_heading_section', 'Update Course Heading Section', 'Update Course Heading Section', 'কোর্স শিরোনাম বিভাগ আপডেট করুন', 'Update Course Heading Section'],
            [1, 'stats', 'Stats', 'Stats', 'পরিসংখ্যান', 'Stats'],
            [1, 'resources', 'Resources', 'Resources', 'সম্পদ', 'Resources'],
            [1, 'prerequisites', 'Prerequisites', 'Prerequisites', 'পূর্বশর্ত', 'Prerequisites'],
            [1, 'outline', 'Outline', 'Outline', 'রূপরেখা', 'Outline'],
            [1, 'menu', 'Menu', 'Menu', 'তালিকা', 'Menu'],
            [1, 'sub_menu', 'Sub Menu', 'Sub Menu', 'সাবমেনু', 'Sub Menu'],
            [1, 'pages', 'Pages', 'Pages', 'পৃষ্ঠাগুলি', 'Pages'],
            [1, 'sub_title', 'Sub Title', 'Sub Title', 'সাব শিরোনাম', 'Sub Title'],
            [1, 'back', 'Back', 'Back', 'পেছনে', 'Back'],
            [1, 'slug', 'Slug', 'Slug', 'স্লাগ', 'Slug'],
            [1, 'overview', 'Overview', 'Overview', 'সংক্ষিপ্ত বিবরণ', 'Overview'],
            [1, 'export_to_csv', 'Export to CSV', 'Export to CSV', 'সিএসভিতে রফতানি করুন', 'Export to CSV'],
            [1, 'export_to_excel', 'Export to Excel', 'Export to Excel', 'এক্সেলে রফতানি করুন', 'Export to Excel'],
            [1, 'export_to_pdf', 'Export to PDF', 'Export to PDF', 'পিডিএফ রফতানি করুন', 'Export to PDF'],
            [1, 'copy_table', 'Copy Table', 'Copy Table', 'টেবিল অনুলিপি করুন', 'Copy Table'],
            [1, 'visibility', 'Visibility', 'visibility', 'দৃষ্টিপাত', 'visibility'],
            [1, 'column_view', 'Column View', 'Column View', 'কলাম ভিউ', 'Column View'],
            [1, 'student_name', 'Student Name', 'Student Name', 'শিক্ষার্থীর নাম', 'Student Name'],
            [1, 'manu', 'Manu', 'Manu', 'ম্যানু', 'Manu'],        
            [17, 'disabled_student', 'Disabled Student', 'Disabled Student', 'অক্ষম শিক্ষার্থী', 'Disabled Student'],
            [2, 'student_info', 'Student Info', 'Información del estudiante', 'শিক্ষার্থীদের তথ্য', 'Info étudiant'],
            [2, 'subject_wise_attendance', 'Subject Wise Attendance ', 'Subject Wise  Attendance ', 'বিষয় উপস্থিতি ', 'Subject Wise  Attendance '],
            [16,'collection_report', 'Collection Report', 'Colección report', 'সংগ্রহ রিপোর্ট', 'Collection Report'],
            [2, 'subject_wise_attendance_report', 'Subject Wise Attendance Report', 'Subject Wise  Attendance Report', 'বিষয় উপস্থিতি রিপোর্ট', 'Subject Wise  Attendance Report'],
            [10, 'homework', 'HomeWork', 'Deberes', 'বাড়ির কাজ', 'Devoirs'],
            [5, 'profit_&_loss', 'Profit & Loss', 'Lucro & loss', 'মুনাফা & ক্ষতি', 'Profit & Loss'],
            [17, 'setup_exam_rule', 'Setup Exam Role', 'Configuración exam rule', 'পরীক্ষা ভূমিকা সেটআপ', 'Configuración exam rule'],
            [17, 'format_settings', 'Format Settings', 'Configuración de format', 'ফর্ম্যাট সেটিংস', 'Format Settings'],
            [10, 'homework_evaluation', 'HomeWork Evaluation', 'Deberes Evaluación', 'বাড়ির কাজ মূল্যায়ন', 'Deberes Évaluation'],
            [1, 'is_published_web_site', 'Is Published Web Site', 'Is Published Web Site', 'প্রকাশিত ওয়েব সাইট', 'Is Published Web Site'],
            [10, 'home_work', 'HomeWork', 'Deberes', 'বাড়ির কাজ', 'Devoirs'],
            [18, 'sms_templete', 'Sms Template', 'Sms Template', 'এসএমএস টেম্পলেট', 'Sms Templete'],
            [18, 'email_templete', 'Email Template', 'Email Template', 'ইমেল টেম্পলেট', 'Email Templete'],


            [18, 'password_reset', 'Password Reset', 'Password Reset', 'পাসওয়ার্ড রিসেট', 'Password Reset'],
            [18, 'student_login_credentials', 'Student Login Credentials', 'Student Login Credentials', 'ছাত্র লগইন শংসাপত্র', 'Student Login Credentials'],
            [18, 'communication_sent_email', 'Communication Sent Email', 'Communication Sent Email', 'যোগাযোগ ইমেল পাঠানো হয়েছে', 'Communication Sent Email'],
            [18, 'frontend_contact', 'Frontend Contact', 'Frontend Contact', 'ফ্রন্টএন্ড যোগাযোগ', 'Frontend Contact'],
            [18, 'parent_login_credentials', 'Parent Login Credentials', 'Parent Login Credentials', 'অভিভাবক লগইন শংসাপত্র', 'Parent Login Credentials'],
            [18, 'student_registration', 'Studen Rtegistration', 'Studen Rtegistration', 'স্টুডেন রেজিস্ট্রেশন', 'Studen Rtegistration'],
            [18, 'student_registration_for_parents', 'Student Registration For Parents', 'Student Registration For Parents', 'অভিভাবকদের জন্য ছাত্র নিবন্ধন', 'Student Registration For Parents'],
            [18, 'staff_login_credentials', 'Staff Login Credentials', 'Staff Login Credentials', 'কর্মীদের লগইন শংসাপত্র', 'Staff Login Credentials'],
            [18, 'dues_payment', 'Dues Payment', 'Dues Payment', 'পাওনা পরিশোধ', 'Dues Payment'],
            [18, 'parent_reject_bank_payment', 'Parent Reject Bank Payment', 'Parent Reject Bank Payment', 'অভিভাবক ব্যাঙ্ক পেমেন্ট প্রত্যাখ্যান করে', 'Parent Reject Bank Payment'],
            [18, 'student_reject_bank_payment', 'Student Reject Bank Payment', 'Student Reject Bank Payment', 'ছাত্র ব্যাঙ্ক পেমেন্ট প্রত্যাখ্যান করে', 'Student Reject Bank Payment'],
            [18, 'wallet_approve', 'Wallet Approve', 'Wallet Approve', 'মানিব্যাগ অনুমোদন', 'Wallet Approve'],
            [18, 'wallet_reject', 'Wallet Reject', 'Wallet Reject', 'মানিব্যাগ প্রত্যাখ্যান', 'Wallet Reject'],
            [18, 'fees_extra_amount_add', 'Fees Extra Amount Add', 'Fees Extra Amount Add', 'ফি অতিরিক্ত পরিমাণ যোগ করুন', 'Fees Extra Amount Add'],
            [18, 'wallet_refund', 'Wallet Refund', 'Wallet Refund', 'ওয়ালেট ফেরত', 'Wallet Refund'],
            
            [18, 'student_admission_in_progress', 'Student Admission In Progress', 'Student Admission In Progress', 'ছাত্র ভর্তি প্রগতি', 'Student Admission In Progress'],
            [18, 'student_admission_for_parent', 'Student Admission For Parent', 'Student Admission For Parent', 'অভিভাবকের জন্য ছাত্র ভর্তি', 'Student Admission For Parent'],
            [18, 'exam_schedule_for_student', 'Exam Schedule For Student', 'Exam Schedule For Student', 'শিক্ষার্থীদের জন্য পরীক্ষার সময়সূচী', 'Exam Schedule For Student'],
            [18, 'exam_schedule_for_parent', 'Exam Schedule For Parent', 'Exam Schedule For Parent', 'পিতামাতার জন্য পরীক্ষার সময়সূচী', 'Exam Schedule For Parent'],
            [18, 'user_login_permission', 'User Login Permission', 'User Login Permission', 'ব্যবহারকারীর লগইন অনুমতি', 'User Login Permission'],
            [18, 'student_attendance_for_parent', 'Student Attendance For Parent', 'Student Attendance For Parent', 'অভিভাবকের জন্য ছাত্র উপস্থিতি', 'Student Attendance For Parent'],
            [18, 'student_absent', 'Student Absent', 'Student Absent', 'ছাত্র অনুপস্থিত', 'Student Absent'],
            [18, 'student_absent_for_parent', 'Student Absent For Parent', 'Student Absent For Parent', 'অভিভাবকের জন্য ছাত্র অনুপস্থিত', 'Student Absent For Parent'],
            [18, 'staff_absent', 'Staff Absent', 'Staff Absent', 'কর্মী অনুপস্থিত', 'Staff Absent'],
            [18, 'student_late', 'Student Late', 'Student Late', 'ছাত্র প্রয়াত', 'Student Late'],
            [18, 'student_late_for_parent', 'Student Late For Parent', 'Student Late For Parent', 'অভিভাবকের জন্য ছাত্র দেরী', 'Student Late For Parent'],
            [18, 'staff_late', 'Staff Late', 'Staff Late', 'স্টাফ দেরী', 'Staff Late'],
            [18, 'student_early_checkout', 'Student Early Checkout', 'Student Early Checkout', 'স্টুডেন্ট আর্লি চেকআউট', 'Student Early Checkout'],
            [18, 'student_checkout', 'Student Checkout', 'Student Checkout', 'ছাত্র চেকআউট', 'Student Checkout'],
            [18, 'staff_credentials', 'Staff Credentials', 'Staff Credentials', 'কর্মীদের শংসাপত্র', 'Staff Credentials'],
            [18, 'student_leave_appllication', 'Student Leave Appllication', 'Student Leave Appllication', 'ছাত্র ছুটি আবেদন', 'Student Leave Appllication'],
            [18, 'student_leave_approve', 'Student Leave Approve', 'Student Leave Approve', 'ছাত্র ছুটি অনুমোদন', 'Student Leave Approve'],
            [18, 'parent_leave_appllication_for_student', 'Parent Leave Appllication For Student', 'Parent Leave Appllication For Student', 'শিক্ষার্থীদের জন্য অভিভাবক ছুটির আবেদন', 'Parent Leave Appllication For Student'],
            [18, 'parent_leave_approve_for_student', 'Parent Leave Approve For Student', 'Parent Leave Approve For Student', 'শিক্ষার্থীর জন্য অভিভাবক ছুটি অনুমোদন', 'Parent Leave Approve For Student'],
            [18, 'staff_leave_appllication', 'Staff Leave Appllication', 'Staff Leave Appllication', 'কর্মীদের ছুটি আবেদন', 'Staff Leave Appllication'],
            [18, 'staff_leave_approve', 'Staff Leave Approve', 'Staff Leave Approve', 'কর্মীদের ছুটি অনুমোদন', 'Staff Leave Approve'],
            [18, 'student_birthday', 'Student Birthday', 'Student Birthday', 'ছাত্র জন্মদিন', 'Student Birthday'],
            [18, 'staff_birthday', 'Staff Birthday', 'Staff Birthday', 'কর্মীদের জন্মদিন', 'Staff Birthday'],
            [18, 'student_library_book_issue', 'Student Library Book Issue', 'Student Library Book Issue', 'ছাত্র লাইব্রেরি বই ইস্যু', 'Student Library Book Issue'],
            [18, 'parent_library_book_issue', 'Parent Library Book Issue', 'Parent Library Book Issue', 'প্যারেন্ট লাইব্রেরি বই ইস্যু', 'Parent Library Book Issue'],
            [18, 'student_re_issue_book', 'Student Re Issue Book', 'Student Re Issue Book', 'ছাত্র পুনরায় ইস্যু বই', 'Student Re Issue Book'],
            [18, 'parent_re_issue_book', 'Parent Re Issue Book', 'Parent Re Issue Book', 'পিতামাতার পুনরায় ইস্যু বই', 'Parent Re Issue Book'],
            [18, 'student_dues_fees', 'Student Dues Fees', 'Student Dues Fees', 'শিক্ষার্থীদের পাওনা ফি', 'Student Dues Fees'],
            [18, 'student_dues_fees_for_parent', 'Student Dues Fees For Parent', 'Student Dues Fees For Parent', 'অভিভাবকের জন্য শিক্ষার্থীদের পাওনা ফি', 'Student Dues Fees For Parent'],
            [18, 'student_absent_notification', 'Student Absent Notification', 'Student Absent Notification', 'ছাত্র অনুপস্থিত বিজ্ঞপ্তি', 'Student Absent Notification'],





            [11, 'send_email_/_sms_', 'Send Email / Sms', 'Enviar correo electrónico / SMS', 'ইমেল / এসএমএস প্রেরণ করুন', 'Envoyer un email / sms'],        
            [11, 'email_/_sms_log', 'Email / Sms Log', 'Email / Sms Log', 'ইমেল / এসএমএস লগ', 'Journal Email / Sms'],
            [12, 'book_list_', 'Book List', 'Lista de libros', 'বইএর তালিকা', 'Liste de livres'],
            [12, 'book_categories', 'Book Categories', 'Categorías de libros', 'বইয়ের বিভাগ', 'Catégories de livre'],
            [10, 'add_homework', 'Add Homework', 'Añadir tarea', 'হোমওয়ার্ক যোগ করুন', 'Ajouter des devoirs'],
            [10, 'homework_list', 'Homework List', 'Lista de tareas', 'হোমওয়ার্ক তালিকা', 'Liste de devoirs'],
            [10, 'evaluation_report', 'Homework Evaluation Report', 'Informe de evaluación de tareas', 'হোম ওয়ার্ক মূল্যায়ন প্রতিবেদন', 'Rapport dévaluation des devoirs'],
            [12, 'issue/return_book', 'Issue/Return Book', 'Libro de emisión / devolución', 'ইস্যু / রিটার্ন বই', 'Livre démission / retour'],
            [15, 'guardian_reports', 'Guardians Reports', 'Informes del guardián', 'অভিভাবক প্রতিবেদন', 'Informes del guardián'],
            [16, 'teacher_class_routine', 'Teacher Class Routine', 'Informe de  para el maestro', 'শিক্ষক শ্রেণির রুটিন ', ' de routine de classe denseignant'],
            [8, 'previous_result', 'Previous Result', 'Previous Result', 'আগে ফলাফল', 'Previous Result'],
            [8, 'previous-record', 'Previous Record', 'Previous Record', 'আগে রেকর্ড', 'Previous Record'],
            [20, 'color_theme', 'Color Theme', 'Color Theme', 'রঙ বিষয়', 'Color Theme'],
            [18, 'news_category', 'News Category', 'Categoría de noticias', 'সংবাদ বিভাগ', 'Catégorie de nouvelles'],
            [20, 'contact_page', 'Contact Page', 'Contact Page', 'যোগাযোগ পৃষ্ঠা', 'Contact Page'],
            [20, 'contact_messages', 'Contact Message', 'Contact Message', 'বার্তা পৃষ্ঠা', 'Contact Message'],
            [0, 'manager', 'Manager', 'manager', 'পরিচালনা ', 'Manager'],
            [1, 'header_manager', 'Header Manager', 'header manager', 'শিরোনাম পরিচালনা', 'header manager'],
            [1, 'header_menu_manager', 'Header Menu  Manager', 'header Menu  manager', 'শিরোনাম তালিকা পরিচালনা', 'header menu  manager'],

            [1, 'module_manager', 'Module Manager', 'Module manager', 'মডিউল পরিচালনা', 'Module Manager'],
            [1, 'utilities', 'Utilities', 'Utilities', 'উপযোগিতা', 'Module Manager'],
            [1, 'optional_subject_setup', 'Optional Subject Setup', 'Optional Subject Setup', 'ঐচ্ছিক বিষয় সেটআপ', 'Optional Subject Setup'],
            [1, 'jitsi', 'Jitsi', 'Jitsi', 'জেটসি', 'Jitsi'],          
            [2, 'course_category', 'Course Category', 'Course Category', 'কোর্স বিভাগ', 'Course Category'],
            [20, 'header_option', 'Hearder Option', 'Hearder Option', 'শিরোনাম পছন্দ', 'Hearder Option'],
           

            [20, 'api_permission', 'Api Permission', 'Api Permission', 'এপিআই অনুমতি', 'Api Permission'],
            [2, 'pages', 'Page', 'Page', 'পৃষ্ঠা', 'Page'],
            [18, 'meeting_report', 'Meeting Report', 'Meeting Report', 'মিটিং প্রতিবেদন', 'Meeting Report'],
            [16, 'reports', 'Reports', 'Informes', 'প্রতিবেদন', 'Rapports'],
            [10, 'submission', 'Submission', 'Sumisión', 'নমন', 'Soumission'],
            [10, 'attach_file', 'Attach File', 'Adjuntar archivo', 'ফাইল সংযুক্ত', 'Pièce jointe'],
            [10, 'evaluation', 'Evaluation', 'Evaluación', 'মূল্যায়ন', 'Évaluation'],
            [10, 'created_by', 'Created By', 'Creado por', 'দ্বারা সৃষ্টি', 'Créé par'],
            [10, 'complete', 'Complete', 'Completar', 'সম্পূর্ণ', 'Achevée'],
            [10, 'incomplete', 'Incomplete', 'Incompleto', 'অসম্পূর্ণ', 'Incomplet'],
            [11, 'notice_board', 'Notice Board', 'Tablón de anuncios', 'নোটিসবোর্ড', 'Tableau daffichage'],
            [11, 'for_whom', 'For Whom', 'for whom', 'কার জন্য', 'For Whom'],
            [11, 'send_message', 'Send Message', 'Enviar mensaje', 'বার্তা পাঠান', 'Envoyer le message'],
            [17, 'role_&_permission', 'Role Permission', 'Permiso de rol', 'ভূমিকা অনুমতি', 'Permission de rôle'],
            [11, 'send_email', 'Send Email / Sms', 'Enviar correo electrónico / SMS', 'ইমেল / এসএমএস প্রেরণ করুন', 'Envoyer un email / sms'],
            [11, 'email_sms_log', 'Email / Sms Log', 'Email / Sms Log', 'ইমেল / এসএমএস লগ', 'Journal Email / Sms'],
            [11, 'event', 'Event', 'Evento', 'ঘটনা', 'un événement'],
            [11, 'notices', 'Notices', 'Avisos', 'নোটিশ', 'Les avis'],
            [11, 'notice', 'Notice', 'darse cuenta', 'বিজ্ঞপ্তি', 'Remarquer'],
            [11, 'publish', 'Publish', 'Publicar', 'প্রকাশ করা', 'Publier'],
            [11, 'add_notice', 'Add Notice', 'Añadir aviso', 'বিজ্ঞপ্তি যুক্ত করুন', 'Ajouter un avis'],
            [11, 'add_a_notice', 'Add a Notice', 'Añadir un aviso', 'একটি নোটিশ যুক্ত করুন', 'Ajouter un avis'],
            [11, 'publish_on', 'Publish On', 'Publicar en', 'প্রকাশ করুন', 'Publier sur'],
            [11, 'Send_Email_Sms', 'Send Email', 'Enviar correo electrónico', 'ইমেইল পাঠান', 'Envoyer un email'],
            [11, 'sms', 'SMS', 'SMS', 'খুদেবার্তা', 'SMS'],
            [11, 'individual', 'Individual', 'Individual', 'স্বতন্ত্র', 'Individuel'],
            [11, 'select_all', 'Select All', 'Seleccionar todo', 'সমস্ত নির্বাচন করুন', 'Tout sélectionner'],
            [11, 'For_Sending_Email', 'For Sending Email / Sms, It may take some seconds. So please take patience.', 'Para enviar correo electrónico / SMS, puede tardar unos segundos. Así que por favor ten paciencia.', 'ইমেল / এসএমএস প্রেরণের জন্য, এটি কয়েক সেকেন্ড সময় নিতে পারে। তাই দয়া করে ধৈর্য ধরুন।', 'Pour lenvoi demails / sms, cela peut prendre quelques secondes. Alors sil vous plaît prenez patience.'],
            [11, 'send', 'Send', 'Enviar', 'পাঠান', 'Envoyer'],
            [11, 'start_date', 'Start Date', 'Fecha de inicio', 'শুরুর তারিখ', 'Date de début'],
            [11, 'to_date', 'To Date', 'Hasta la fecha', 'এখন পর্যন্ত', 'À ce jour'],
            [11, 'from_date', 'from Date', 'partir de la fecha', 'তারিখ হইতে', 'partir de la date'],
            [11, 'details', 'Details', 'Detalles', 'বিস্তারিত', 'Détails'],
            [11, 'notice_date', 'Notice Date', 'Fecha de notificacion', 'নোটিশ তারিখ', 'Date davis'],
            [11, 'update_content', 'Update content', 'Actualizar contenido', 'সামগ্রী আপডেট করুন', 'Mettre à jour le contenu'],
            [11, 'communicate', 'Communicate', 'Comunicar', 'যোগাযোগ করুন', 'Communiquer'],
            
            [11, 'student_approve_message', 'Student Approve Message', 'Student Approve Message', 'ছাত্র অনুমোদনের বার্তা', 'Student Approve Message'],
            [11, 'student_registration_message', 'Student Registration Message', 'Student Registration Message', 'ছাত্র নিবন্ধনের বার্তা', 'Student Registration Message'],
            [11, 'student_admission_message', 'Student Admission Message', 'Student Admission Message', 'যোগাযোগ করুন', 'Communiquer'],
            [11, 'exam_schedule_message', 'Exam Schedule Message', 'Exam Schedule Message', 'পরীক্ষার সময়সূচী বার্তা', 'Exam Schedule Message'],
            [11, 'dues_fees_message', 'Dues Fees Message', 'Dues fees message', 'বকেয়া ফি বার্তা', 'Communiquer'],
            [11, 'communicate', 'Communicate', 'Comunicar', 'যোগাযোগ করুন', 'Communiquer'],
            [11, 'varriables', 'Varriables', 'Varriables', 'পরিবর্তনশীল', 'Varriables'],
            

            [12, 'library', 'Library', 'Biblioteca', 'গ্রন্থাগার', 'Bibliothèque'],
            [12, 'add_book', 'Add Book', 'Añadir libro', 'বই যোগ করুন', 'Ajouter un livre'],
            [12, 'book_list', 'Book List', 'Lista de libros', 'বইএর তালিকা', 'Liste de livres'],
            [12, 'book_category', 'Book Categories', 'Categorías de libros', 'বইয়ের বিভাগ', 'Catégories de livre'],
            [12, 'library_member', 'Add Member', 'Añadir miembro', 'সদস্য যোগ করুন', 'Ajouter un membre'],
            [12, 'member_list', 'Issue/Return Book', 'Libro de emisión / devolución', 'ইস্যু / রিটার্ন বই', 'Livre démission / retour'],
            [12, 'all_issued_book', 'All Issued Book', 'Todo el libro publicado', 'সমস্ত ইস্যু করা বই', 'Tous les livres publiés'],
            [12, 'edit_book', 'Edit Book', 'Editar libro', 'সম্পাদনা বই', 'Editer le livre'],
            [12, 'book', 'Book', 'Libro', 'বই', 'Livre'],
            [12, 'book_title', 'Book Title', 'Titulo del libro', 'বইয়ের শিরোনাম', 'Titre de livre'],
            [12, 'select_book_category', 'Select Book Category', 'Seleccionar categoría de libro', 'বইয়ের বিভাগ নির্বাচন করুন', 'Sélectionnez une catégorie de livre'],
            [12, 'isbn', 'ISBN', 'ISBN', 'আইএসবিএন', 'ISBN'],
            [12, 'publisher', 'Publisher', 'Editor', 'প্রকাশক', 'Éditeur'],
            [12, 'author_name', 'Author Name', 'Nombre del autor', 'লেখকের নাম', 'Nom de lauteur'],
            [12, 'rack', 'Rack', 'Estante', 'তাক', 'Grille'],
            [12, 'quantity', 'Quantity', 'Cantidad', 'পরিমাণ', 'Quantité'],
            [12, 'book_price', 'Book Price', 'Precio del libro', 'বইয়ের দাম', 'Prix ​​du livre'],
            [12, 'price', 'Price', 'Precio', 'মূল্য', 'Prix'],
            [12, 'category_name', 'Category Name', 'nombre de la categoría', 'বিভাগ নাম', 'Nom de catégorie'],
            [12, 'add_member', 'Add Member', 'Añadir miembro', 'সদস্য যোগ করুন', 'Ajouter un membre'],
            [12, 'member', 'Member', 'Miembro', 'সদস্য', 'Membre'],
            [12, 'member_type', 'Member Type', 'Tipo de miembro', 'সদস্যের প্রকার', 'Type de membre'],
            [12, 'select_student', 'Select Student', 'Seleccionar estudiante', 'ছাত্র নির্বাচন করুন', 'Sélectionnez étudiant'],
            [12, 'issue_books', 'Issue Books', 'Libros de emisión', 'বই ইস্যু', 'Livres de questions'],
            [12, 'full_name', 'Full Name', 'Nombre completo', 'পুরো নাম', 'Nom complet'],
            [12, 'issue_return_Book', 'Issue / Return Book', 'Libro de emisión / devolución', 'ইস্যু / রিটার্ন বই', 'Livre démission / retour'],
            [12, 'issued_Book_List', 'Issued Book List', 'Lista de libros emitidos', 'জারি করা বইয়ের তালিকা', 'Liste des livres publiés'],
            [12, 'select_Book_Name', 'Select Book Name', 'Seleccione el nombre del libro', 'বইয়ের নাম নির্বাচন করুন', 'Sélectionnez le nom du livre'],
            [12, 'search_By_Book_ID', 'Search By Book ID', 'Buscar por ID de libro', 'বুক আইডি দ্বারা অনুসন্ধান করুন', 'Rechercher par numéro de livre'],
            [12, 'author', 'Author', 'Autor', 'লেখক', 'Auteur'],
            [12, 'library_book_issue', 'Library Book Issue', 'Número de libro de la biblioteca', 'লাইব্রেরির বই ইস্যু', 'Problème de livre de bibliothèque'],
            [12, 'staff_name', 'Staff Name', 'Nombre del personal', 'স্টাফ নাম', 'Nom du personnel'],
            [12, 'select_book', 'Select Book', 'Seleccionar libro', 'বই নির্বাচন করুন', 'Sélectionnez un livre'],
            [12, 'issue_book', 'Issue Book', 'Libro de temas', 'ইস্যু বুক', 'Numéro de livre'],
            [12, 'issued_book', 'Issued Book', 'Libro publicado', 'ইস্যু করা বই', 'Livre publié'],
            [12, 'book_number', 'Book Number', 'Número de libro', 'বইয়ের নম্বর', 'Numéro du livre'],
            [12, 'status', 'Status', 'Estado', 'অবস্থা', 'Statut'],
            [12, 'issue_date', 'Issue Date', 'Fecha de asunto', 'প্রদানের তারিখ', 'Date démission'],
            [12, 'return_this_book', 'Are you sure to Return This Book ?', '¿Seguro que regresas este libro?', 'আপনি কি এই বইটি ফেরত দেওয়ার বিষয়ে নিশ্চিত?', 'Êtes-vous sûr de retourner ce livre?'],
            [12, 'return_date', 'Return Date', 'Fecha de regreso', 'ফেরার তারিখ', 'Date de retour'],
            [13, 'inventory', 'Inventory', 'Inventario', 'জায়', 'Inventaire'],
            [13, 'item_category', 'Item Category', 'Categoría de artículo', 'আইটেম বিভাগ', 'Catégorie darticle'],
            [13, 'item_list', 'Item List', 'Lista de articulos', 'উপকরণ তালিকা', 'Liste des articles'],
            [13, 'item_store', 'Item Store', 'Tienda de articulos', 'আইটেম স্টোর', 'Magasin darticles'],
            [13, 'warehouse', 'Warehouse', 'Warehouse', 'গুদাম', 'Warehouse'],
            [13, 'store', 'Store', 'Store', 'স্টোর', 'Store'],
            [13, 'supplier', 'Supplier', 'Proveedor', 'সরবরাহকারী', 'Fournisseur'],
            [13, 'item_receive', 'Item Receive', 'El artículo recibe', 'আইটেম রিসিভ', 'Point recevoir'],
            [13, 'item_receive_list', 'Item Receive List', 'Lista de artículos recibidos', 'আইটেমের প্রাপ্তির তালিকা', 'Item Receive List'],
            [13, 'item_sell', 'Item Sell', 'Venta de artículos', 'আইটেম বিক্রয়', 'Article Vendre'],
            [13, 'item_issue', 'Item Issue', 'Emisión del artículo', 'আইটেম ইস্যু', 'Question darticle'],
            [13, 'select_item_category', 'Select Item Category', 'Seleccione la categoría del artículo', 'আইটেম বিভাগ নির্বাচন করুন', 'Sélectionner une catégorie darticle'],
            [13, 'selected', 'Selected', 'Seleccionado', 'নির্বাচিত', 'Choisi'],
            [13, 'total_in_stock', 'Total in Stock', 'Total en Stock', 'মোট স্টক', 'Total en stock'],
            [13, 'store_name', 'Store Name', 'Nombre de la tienda', 'দোকানের নাম', 'Nom du magasin'],
            [13, 'store_number', 'Store Number', 'Número de tienda', 'স্টোর নম্বর', 'Numéro de magasin'],
            [13, 'company', 'Company', 'Empresa', 'প্রতিষ্ঠান', 'Entreprise'],
            [13, 'contact_person_name', 'Contact Person Name', 'Nombre del Contacto', 'যোগাযোগ ব্যক্তির নাম', 'nom de contacte dune personne'],
            [13, 'contact_person', 'Contact Person', 'Persona de contacto', 'যোগাযোগ', 'Contact'],
            [13, 'receive_details', 'Receive Details', 'Recibir detalles', 'বিশদ গ্রহণ করুন', 'Recevoir les détails'],
            [13, 'select_supplier', 'Select Supplier', 'Seleccionar Proveedor', 'সরবরাহকারী নির্বাচন করুন', 'Sélectionner un fournisseur'],
            [13, 'receive_date', 'Receive Date', 'Fecha de recepción', 'গ্রহণের তারিখ', 'date de réception'],
            [13, 'product_name', 'Product Name', 'nombre del producto', 'পণ্যের নাম', 'Nom du produit'],
            [13, 'unit_price', 'Unit Price', 'Precio unitario', 'একক দাম', 'Prix ​​unitaire'],
            [13, 'sub_total', 'Sub Total', 'Sub Total', 'সাব টোটাল', 'Total partiel'],
            [13, 'full_paid', 'Full Paid', 'Completo pagado', 'ফুল পেইড', 'Complet payé'],
            [13, 'total_paid', 'Total Paid', 'Total pagado', 'পুরাপুরি পরিশোধিত', 'Total payé'],
            [13, 'total_due', 'Total Due', 'Total a pagar', 'মোট বাকি', 'Total dû'],
            [13, 'receive', 'Receive', 'Recibir', 'গ্রহণ করা', 'Recevoir'],
            [13, 'new', 'New', 'Nuevo', 'নতুন', 'Nouveau'],
            [13, 'total_quantity', 'Total Quantity', 'Cantidad total', 'মোট পরিমাণ', 'Quantité totale'],
            [13, 'partial_paid', 'Partial Paid', 'Parcial pagado', 'আংশিক প্রদেয়', 'Partiellement payé'],
            [13, 'unpaid', 'Unpaid', 'No pagado', 'অবৈতনিক', 'Non payé'],
            [13, 'if', 'If', 'If', 'যদি', 'If'],
            [13, 'will_be', 'Will be', 'Will be', 'হবে', 'Will be'],
            [13, 'shift', 'Shift', 'Shift', 'শিফট', 'Shift'],
            [13, 'casier', 'Casier', 'Casier', 'ক্যাসিয়ার', 'Casier'],
            [13, 'officer', 'Officer', 'Officer', 'অফিসার', 'Officer'],
            [13, 'refund', 'Refund', 'Reembolso', 'প্রত্যর্পণ', 'Rembourser'],
            [13, 'buyer', 'Buyer', 'Comprador', 'ক্রেতা', 'Acheteur'],
            [13, 'issue_item', 'Issue Item', 'Elemento de emisión', 'আইটেম ইস্যু করুন', 'Point démission'],
            [13, 'issue_a_item', 'Issue a Item', 'Emitir un artículo', 'একটি আইটেম ইস্যু করুন', 'Émettre un article'],
            [13, 'user_type', 'User Type', 'Tipo de usuario', 'ব্যবহারকারীর ধরন', 'Type dutilisateur'],
            [13, 'select_student_for_issue', 'Select Student For Issue', 'Seleccionar estudiante para su emisión', 'ইস্যু করার জন্য শিক্ষার্থী নির্বাচন করুন', 'Sélectionner un étudiant pour lédition'],
            [13, 'issue_to', 'Issue To', 'Emitido a', 'ইস্যু করতে', 'Issue to'],
            [13, 'issued_item_list', 'Issued Item List', 'Lista de elementos emitidos', 'জারি করা আইটেমের তালিকা', 'Liste darticles publiés'],
            [13, 'issued', 'Issued', 'Emitido', 'ইস্যু করা', 'Publié'],
            [13, 'returned', 'Returned', 'Devuelto', 'ফেরৎ', 'Revenu'],
            [13, 'cancel_the_record', 'You are about to cancel the record. This cannot be undone. are you sure?', 'Estás a punto de cancelar el registro. Esto no se puede deshacer. ¿Estás seguro?', 'আপনি রেকর্ডটি বাতিল করতে চলেছেন। এটা অসম্পূর্ণ থাকতে পারে না. তুমি কি নিশ্চিত?', 'Vous êtes sur le point dannuler lenregistrement. Ça ne peut pas être annulé. êtes-vous sûr?'],
            [13, 'return', 'Return', 'Regreso', 'প্রত্যাবর্তন', 'Revenir'],
            [13, 'purchase_details', 'Purchase Details', 'Detalles de la compra', 'ক্রয়ের বিশদ', 'Les détails dachat'],
            [14, 'transport', 'Transport', 'Transporte', 'পরিবহন', 'Transport'],
            [14, 'routes', 'Routes', 'Rutas', 'রুট', 'Itinéraires'],
            [14, 'vehicle', 'Vehicle', 'Vehículo', 'বাহন', 'Véhicule'],
            [14, 'assign_vehicle', 'Assign Vehicle', 'Asignar vehículo', 'যানবাহন বরাদ্দ করুন', 'Assigner un véhicule'],
            [14, 'student_transport', 'Student Transport', 'Informe de transporte de', 'ছাত্র পরিবহন ', 'Rapport de transport'],
            [14, 'student_transport_report', 'Student Transport Report', 'Informe de transporte de estudiantes', 'ছাত্র পরিবহন প্রতিবেদন', 'Rapport de transport étudiant'],
            [14, 'transport_route', 'Transport Route', 'Ruta de transporte', 'পরিবহন রুট', 'Route de transport'],
            [14, 'route', 'Route', 'Ruta', 'রুট', 'Route'],
            [14, 'route_title', 'Route Title', 'Título de la ruta', 'রুটের শিরোনাম', 'Titre de la route'],
            [14, 'fare', 'Fare', 'Tarifa', 'ভাড়া', 'Tarif'],
            [14, 'model', 'Model', 'Modelo', 'মডেল', 'Modèle'],
            [14, 'year_made', 'Year Made', 'Año hecho', 'বছর তৈরি', 'Année de fabrication'],
            [14, 'select_driver', 'Select Driver', 'Seleccione Driver', 'ড্রাইভার নির্বাচন করুন', 'Sélectionnez le pilote'],
            [14, 'license', 'License', 'Licencia', 'লাইসেন্স', 'Licence'],
            [14, 'select_route', 'Select Route', 'Seleccione Ruta', 'রুট নির্বাচন করুন', 'Sélectionnez un itinéraire'],
            [14, 'select_vehicle', 'Select Vehicle', 'Seleccionar vehiculo', 'যানবাহন নির্বাচন করুন', 'Choisir un véhicule'],
            [14, 'father_phone', 'Fathers Phone', 'Telefono del padre', 'বাবার ফোন', 'Téléphone du père'],
            [14, 'mother_name', 'Mothers Name', 'Nombre de la madre', 'মায়ের নাম', 'Le nom de la mère'],
            [14, 'mother_phone', 'Mothers Phone', 'Teléfono de la madre', 'মায়েদের ফোন', 'Téléphone de la mère'],
            [15, 'dormitory', 'Dormitory', 'Dormitorio', 'ছাত্রাবাস', 'Dortoir'],
            [15, 'dormitory_rooms', 'Dormitory Rooms', 'Dormitorios', 'ডরমেটরি রুম', 'Dortoirs'],
            [15, 'room_type', 'Room Type', 'Tipo de habitación', 'ঘরের বিবরণ', 'Type de chambre'],
            [15, 'student_dormitory_report', 'Student Dormitory Report', 'Informe del dormitorio de estudiantes', 'ছাত্র ছাত্রাবাস প্রতিবেদন', 'Rapport du dortoir des étudiants'],
            [15, 'number_of_bed', 'Number Of Bed', 'Numero de cama', 'বিছানা সংখ্যা', 'Nombre de lit'],
            [15, 'cost_per_bed', 'Cost Per Bed', 'Costo por cama', 'প্রতি বিছানা খরচ', 'Coût par lit'],
            [15, 'no_of_bed', 'NO. OF BEd', 'NO. DE LA CAMA', 'কোন। বিএড এর', 'NON. DE LIT'],
            [15, 'dormitory_list', 'Dormitory List', 'Lista de dormitorios', 'আস্তানা তালিকা', 'Liste des dortoirs'],
            [15, 'boys', 'Boys', 'Muchachos', 'বয়েজ', 'Garçons'],
            [15, 'girls', 'Girls', 'Chicas', 'গার্লস', 'Filles'],
            [15, 'intake', 'Intake', 'Consumo', 'ঘেরা জমি', 'Admission'],
            [15, 'select_dormitory', 'Select Dormitory', 'Dormitorio selecto', 'ডরমেটরি নির্বাচন করুন', 'Sélectionnez un dortoir'],
            [15, 'guardian_phone', 'Guardians Phone', 'Teléfono del guardián', 'অভিভাবকরা ফোন', 'Téléphone du gardien'],
            [16, 'reports', 'Reports', 'Informes', 'প্রতিবেদন', 'Rapports'],
            [16, 'student_report', 'Student Report', 'Informe del estudiante', 'ছাত্র প্রতিবেদন', 'Rapport détudiant'],
            [16, 'guardian_report', 'Guardian Reports', 'Informes del tutor', 'গার্ডিয়ান রিপোর্টস', 'Rapports de gardien'],
            [16, 'student_history', 'Student History', 'Historia del estudiante', 'ছাত্র ইতিহাস', 'Histoire des étudiants'],
            [16, 'student_login_report', 'Student Login Report', 'Informe de inicio de sesión del estudiante', 'ছাত্র লগইন রিপোর্ট', 'Rapport de connexion détudiant'],
            [16, 'fees_statement', 'Fees Statement', 'Declaración de honorarios', 'ফি বিবৃতি', 'Relevé des frais'],
            [16, 'balance_fees_report', 'Balance Fees Report', 'Informe de comisiones de saldo', 'ব্যালেন্স ফি রিপোর্ট', 'Bilan des frais'],
            [16, 'transaction_report', 'Transaction Report', 'Reporte de transacción', 'লেনদেন রিপোর্ট', 'Rapport de transaction'],
            [16, 'transaction', 'Transaction', 'Transacción', 'লেনদেন', 'Transaction'],
            [16, 'credit', 'Credit', 'Transacción', 'ক্রেডিট', 'Credit'],
            [16, 'debit', 'Debit', 'Debit', 'ডেবিট', 'Debit'],
            [16, 'loss', 'Loss', 'Loss', 'ক্ষতি', 'Loss'],
            [16, 'class_report', 'Class Report', 'Informe de clase', 'ক্লাস রিপোর্ট', 'Rapport de classe'],
            [16, 'merit_list_report', 'Merit List Report', 'Informe de la lista de méritos', 'মেধা তালিকা প্রতিবেদন', 'Rapport de liste de mérite'],
            [16, 'online_exam_report', 'Online Exam Report', 'Informe de examen en línea', 'অনলাইন পরীক্ষার রিপোর্ট', 'Rapport dexamen en ligne'],
            [16, 'mark_sheet_report', 'Mark Sheet Report', 'Informe de hoja de marcas', 'মার্ক শীট রিপোর্ট', 'Rapport de feuille de marque'],
            [16, 'tabulation_sheet_report', 'Tabulation Sheet Report', 'Informe de hoja de tabulación', 'ট্যাবুলেশন শীট রিপোর্ট', 'Rapport de tabulation'],
            [16, 'tabulation_sheet', 'Tabulation Sheet', 'Informe de hoja', 'ট্যাবুলেশন শীট', 'de tabulation'],
            [16, 'student_fine_report', 'Student Fine Report', 'Informe de estudiante bien', 'শিক্ষার্থীর ফাইন রিপোর্ট', 'Rapport de létudiant bien'],
            [16, 'user_log', 'User Log', 'Registro de usuario', 'ব্যবহারকারী লগ', 'Journal de lutilisateur'],
            [16, 'exam_routine', 'Exam Routine', 'Rutina de examen', 'পরীক্ষার রুটিন', 'Routine dexamen'],
            [16, 'select_type', 'Select Type', 'Seleccione tipo', 'প্রকার নির্বাচন করুন', 'Sélectionner le genre'],
            [16, 'select_gender', 'Select Gender', 'Seleccione género', 'লিংগ নির্বাচন', 'Sélectionnez le sexe'],
            [16, 'nid', 'NID', 'NID', 'জাতীয় পরিচয়পত্র', 'NID'],
            [16, 'Birth_Certificate_Number', 'Birth Certificate Number', 'Número de Certificado de Nacimiento', 'জন্ম শংসাপত্র নম্বর', 'Numéro Acte de Naissance'],
            [16, 'select_admission_year', 'Select admission Year', 'Seleccione el año de admisión', 'ভর্তি বছর নির্বাচন করুন', 'Sélectionnez lannée dadmission'],
            [16, 'start_end', 'Start-End', 'Inicio fin', 'শুরু শেষ', 'Début Fin'],
            [16, 'student_login_info', 'Student Login Info', 'Información de inicio de sesión del estudiante', 'শিক্ষার্থী লগইন তথ্য', 'Informations de connexion des étudiants'],
            [16, 'login_info_report', 'Login Info Report', 'Informe de información de inicio de sesión', 'লগইন তথ্য প্রতিবেদন', 'Login Info Report'],
            [16, 'username', 'Username', 'Nombre de usuario', 'ব্যবহারকারীর নাম', 'Nom dutilisateur'],
            [16, 'password', 'Password', 'Contraseña', 'পাসওয়ার্ড', 'Mot de passe'],
            [16, 'logout', 'Logout', 'Logout', 'প্রস্থান', 'Logout'],
            [16, 'as', 'as', 'as', 'হিসাবে', 'as'],
            [16, 'parent', 'Parent', 'Padre', 'মাতা', 'Parent'],
            [16, 'reset', 'Reset', 'Reiniciar', 'রিসেট', 'Réinitialiser'],
            [16, 'due_date', 'Due Date', 'Fecha de vencimiento', 'নির্দিষ্ট তারিখ', 'Date déchéance'],
            [16, 'partial', 'Partial', 'Parcial', 'আংশিক', 'Partiel'],
            [16, 'discount_of', 'Discount of', 'Descuento de', 'ছাড়', 'Remise de'],         
            [16, 'paid_fees', 'Paid Fees', 'Honorarios pagados', 'প্রদত্ত ফি', 'Frais payés'],
            [16, 'fees_collection_details', 'Fees Collection Details', 'Detalles de la colección', 'ফি সংগ্রহের বিশদ', 'Frais Collection Détails'],
            [16, 'number_of_student', 'Number Of Student', 'Numero de estudiante', 'ছাত্র সংখ্যা', 'Nombre détudiant'],
            [16, 'total_subjects_assigned', 'Total Subjects assigned', 'Total de asignaturas asignadas', 'বরাদ্দকৃত মোট বিষয়', 'Nombre total de sujets assignés'],
            [16, 'collection', 'Collection', 'Colección', 'সংগ্রহ', 'Collection'],
            [16, 'due', 'Due', 'Debido', 'বাকি', 'Dû'],
            [16, 'fees_details', 'Fees Details', 'Detalles de tarifas', 'ফি বিবরণ', 'Détails des frais'],
            [16, 'class_routine_report', 'Class Routine Report', 'Informe de rutina de la clase', 'ক্লাস রুটিন রিপোর্ট', 'Rapport de routine de classe'],
            [16, 'report', 'Report', 'Informe', 'প্রতিবেদন', 'rapport'],
            [16, 'teacher_class_routine_report', 'Teacher Class Routine Report', 'Informe de rutina para el maestro', 'শিক্ষক শ্রেণির রুটিন প্রতিবেদন', 'Rapport de routine de classe denseignant'],
            [16, 'select_teacher', 'Select Teacher', 'Seleccionar profesor', 'শিক্ষক নির্বাচন করুন', 'Sélectionnez un enseignant'],
            [16, 'school_management_system', 'School Management System', 'Sistema de gestión escolar', 'স্কুল পরিচালনা ব্যবস্থা', 'Système de gestion scolaire'],
            [16, 'united_states_of_america', 'House 25, Road 27, Block B, 54th Floor, USA', 'House 25, Road 27, Block B, Nueva York, USA', 'বাড়ি 25, রোড 27, ব্লক বি, 54 তলা, মার্কিন যুক্তরাষ্ট্র', 'USA'],
            [16, 'order_of_merit_list', 'Order of merit list', 'Lista de orden de mérito', 'মেধা তালিকার অর্ডার', 'Ordre de mérite'],
            [16, 'position', 'Position', 'Posición', 'অবস্থান', 'Position'],
            [16, 'average', 'Average', 'Promedio', 'গড়', 'Moyenne'],
            [16, 'obtained_marks', 'Obtained Marks', 'Marcas obtenidas', 'প্রাপ্ত নম্বর', 'Obtenu Marques'],
            [16, 'top_obtained_mark', 'Top Obtained Mark', 'Mejor marca obtenida', 'শীর্ষ প্রাপ্ত চিহ্ন', 'Top obtenu la marque'],
            [16, 'student_terminal_report', 'Student Terminal Report', 'Informe de terminal de estudiante', 'ছাত্র টার্মিনাল রিপোর্ট', 'Rapport de fin détude'],
            [16, 'progress_card_report', 'Progress Card Report', 'Informe De Progreso', 'অগ্রগতি কার্ড রিপোর্ট', 'Rapport De Carte De Progression'],
            [16, 'progress_card', 'Progress Card', 'Progress Card', 'অগ্রগতি কার্ড', 'Progress Card'],
            [16, 'position_in_class', 'Position in Class', 'Posición en clase', 'ক্লাসে পজিশন', 'Position en classe'],
            [16, 'class_test', 'Class Test', 'Prueba de clase', 'ক্লাস টেস্ট', 'Test de classe'],
            [16, 'remarks', 'Remarks', 'Observaciones', 'মন্তব্য', 'Remarques'],
            [16, 'user', 'User', 'Usuario', 'ব্যবহারকারী', 'Utilisateur'],
            [16, 'ip', 'IP', 'IP', 'আইপি', 'IP'],
            [16, 'login_time', 'Login Time', 'Hora de inicio de sesión', 'লগইন সময়', 'Heure de connexion'],
            [16, 'user_agent', 'User Agent', 'Agente de usuario', 'ব্যবহারিক দূত', 'Agent utilisateur'],

            [16,'monthly', 'Monthly', 'Monthly', 'মাসিক', 'Monthly'],            
            [16,'fees_report', 'Fees Report', 'Informe de tarifas', 'ফি রিপোর্ট', 'Rapport de frais'],
            [16,'monthly_collection_report', 'Monthly Collection Report', 'Monthly Colección report', 'মাসিক সংগ্রহ রিপোর্ট', 'Monthly Collection Report'],

            [17, 'authentication', 'Authentication', 'Autenticación', 'প্রমাণীকরণ', 'Authentification'],
            [17, 'token', 'Token', 'Simbólico', 'টোকেন', 'Jeton'],
            [17, 'registered_phone_number', 'Registered Phone Number', 'Número de teléfono registrado', 'নিবন্ধিত ফোন নম্বর', 'Numéro de téléphone enregistré'],
            [17, 'authentication_key_SId', 'Authentication Key SId', 'Clave de autenticación SId', 'প্রমাণীকরণ কী এসআইডি', 'Clé dauthentification SId'],
            [17, 'sender', 'Sender', 'Remitente', 'প্রেরকের', 'Expéditeur'],
            [17, 'country_code', 'Country Code', 'Código de país', 'কান্ট্রি কোড', 'Code postal'],
            [17, 'select_serial', 'Select serial', 'Seleccione serial', 'সিরিয়াল নির্বাচন করুন', 'Sélectionnez série'],
            [17, 'day_list', 'Day list', 'Lista de días', 'দিনের তালিকা', 'Liste de jour'],
            [17, 'serial', 'Serial', 'De serie', 'ক্রমিক', 'En série'],
            [17, 'upload_from_local_directory', 'Upload From Local Directory', 'Subir desde el directorio local', 'স্থানীয় ডিরেক্টরি থেকে আপলোড করুন', 'Télécharger depuis le répertoire local'],
            [17, 'file', 'File', 'Expediente', 'ফাইল', 'Fichier'],
            [17, 'cron_secret_key', 'Cron Secret Key', 'Clave secreta de Cron', 'ক্রোন সিক্রেট কী', 'Cron Secret Key'],
            [17, 'generate_key', 'Generate key', 'Generar clave', 'কী উত্পন্ন', 'Générer une clé'],
            [17, 'database_backup_list', 'Database Backup List', 'Lista de respaldo de la base de datos', 'ডাটাবেস ব্যাকআপ তালিকা', 'Liste de sauvegarde de la base de données'],
            [17, 'backup', 'Backup', 'Apoyo', 'ব্যাকআপ', 'Sauvegarde'],
            [17, 'full', 'Full', 'Full', 'সম্পূর্ণ', 'Full'],
            [17, 'project', 'Project', 'Project', 'প্রকল্প', 'Project'],
            [17, 'disabled', 'Disabled', 'Disabled', 'অক্ষম', 'Disabled'],
            [17, 'size', 'Size', 'Size', 'আকার', 'Size'],
            [17, 'created_date_time', 'Created Date Time', 'Fecha de creación', 'তৈরি তারিখের সময়', 'Date de création heure'],
            [17, 'backup_files', 'Backup Files', 'Archivos de respaldo', 'ব্যাকআপ ফাইল', 'Fichiers de sauvegarde'],
            [17, 'weekend', 'Weekend', 'Fin de semana', 'সপ্তাহান্তিক কাল', 'Weekend'],
            [17, 'week', 'Week', 'semana', 'সপ্তাহ', 'Week'],
            [17, 'restore', 'Restore', 'Restaurar', 'প্রত্যর্পণ করা', 'Restaurer'],
            [17, 'default', 'Default', 'Defecto', 'ডিফল্ট', 'Défaut'],
            [17, 'module', 'Module', 'Módulo', 'মডিউল', 'Module'],
            [17, 'module_link', 'Module Link', 'Enlace del módulo', 'মডিউল লিঙ্ক', 'Lien de module'],
            [17, 'permission', 'Permission', 'Permiso', 'অনুমতি', 'Autorisation'],
            [17, 'site_title', 'Site Title', 'Título del sitio', 'সাইট শিরোনাম', 'Titre du site'],
            [17, 'select_session', 'Select Academic Year', 'Seleccionar Academic Year', 'সেশন নির্বাচন করুন', 'Sélectionnez une Academic Year'],
            [17, 'select_date_format', 'Select Date Format', 'Seleccione el formato de fecha', 'তারিখ ফর্ম্যাট নির্বাচন করুন', 'Sélectionnez le format de date'],
            [17, 'format', 'Format', 'Format', 'ফর্ম্যাট', 'Format'],
            [17, 'select_currency', 'Select Currency', 'Seleccione el tipo de moneda', 'কারেন্সি নির্বাচন করুন', 'Sélectionnez la devise'],
            [17, 'currency_symbol', 'Currency Symbol', 'Símbolo de moneda', 'মুদ্রার প্রতীক', 'Symbole de la monnaie'],
            [17, 'school_address', 'School Address', 'Dirección de Escuela', 'স্কুলের ঠিকানা', 'Adresse de lécole'],
            [17, 'update_language', 'Update Language', 'Actualizar idioma', 'ভাষা আপডেট করুন', 'Mise à jour de la langue'],
            [17, 'language_setup', 'Language Setup', 'Configuración de idioma', 'ভাষা সেটআপ', 'Configuration de la langue'],
            [17, 'starting', 'Starting', 'Starting', 'শুরু হচ্ছে', 'Starting'],
            [17, 'term', 'Term', 'Term', 'শব্দ', 'Term'],
            [17, 'optional_subject', 'Optional Subject', 'Optional Subject', 'ঐচ্ছিক বিষয়', 'Optional Subject'],
            [17, 'manage_currency', 'Manage Currency', 'Manage Currency', 'মুদ্রা পরিচালনা করুন', 'Manage Currency'],
            [17, 'send_through', 'Send Through', 'Send Through', 'মাধ্যমে প্রেরণ করুন', 'Send Through'],
            [17, 'custom_progress_card_report', 'Custom Progress Card Report', 'Custom Progress Card Report', 'কাস্টম অগ্রগতি কার্ড রিপোর্ট', 'Custom Progress Card Report'],
            [17, 'due_amount', 'Due Amount', 'Due Amount', 'বাকি টাকা', 'Due Amount'],
            [17, 'paid_amount', 'Paid Amount', 'Paid Amount', 'দেওয়া পরিমাণ', 'Paid Amount'],
            [17, 'expaire_date', 'Expaire Date', 'Expaire Date', 'মেয়াদ উত্তীর্ণ', 'Expaire Date'],
            [17, 'purchase_date', 'Purchase Date', 'Purchase Date', 'ক্রয় তারিখ', 'Purchase Date'],
            [17, 'package', 'Package', 'Package', 'প্যাকেজ', 'Package'],
            [17, 'sl', 'SL', 'SL', 'এসএল বিভাগ:', 'SL'],
            [17, 'purchase_list', 'Purchase List', 'Purchase List', 'ক্রয়ের তালিকা', 'Purchase List'],
            [17, 'infix_clasified', 'Infix Clasified', 'Infix Clasified', 'ইনফিক্স শ্রেণিবদ্ধ', 'Infix Clasified'],
            [17, 'infix_edu', 'Infix Edu', 'Infix Edu', 'ইনফিক্স এডু', 'Infix Edu'],
            [17, 'select_package', 'Select Package', 'Select Package', 'প্যাকেজ নির্বাচন করুন', 'Select Package'],
            [17, 'thanks', 'Thanks', 'Thanks', 'ধন্যবাদ', 'Thanks'],
            [17, 'team', 'Team', 'Team', 'টীম', 'Team'],
            [17, 'select', 'Select', 'Select', 'নির্বাচন করা', 'Select'],
            [17, 'mark', 'Mark', 'Mark', 'ছাপ', 'Mark'],
            [17, 'fees_groups_details', 'Fees groups Details', 'Fees groups Details', 'ফি গোষ্ঠী বিশদ', 'Fees groups Details'],
            [17, 'staff', 'Staff', 'Staff', 'কর্মী', 'Staff'],
            [17, 'manage-currency', 'Manage Currency', 'Manage Currency', 'মুদ্রা পরিচালনা করুন', 'Manage Currency'],
            [17, 'wise', 'Wise', 'Wise', 'জ্ঞানী', 'Wise'],
            [17, 'system_settings', 'System Settings', 'Ajustes del sistema', 'পদ্ধতি নির্ধারণ', 'Les paramètres du système'],
            [17, 'general_settings', 'General Settings', 'Configuración general', 'সাধারণ সেটিংস', 'réglages généraux'],
            [17, 'email_settings', 'Email Settings', 'Ajustes del correo electrónico', 'ইমেল সেটিংস', 'Paramètres de messagerie'],
            [17, 'email_setting', 'Email Setting', 'Ajustes del correo electrónico', 'ইমেল সেটিংস', 'Paramètres de messagerie'],

            [17, 'payment_method_settings', 'Payment Method Settings', 'Configuración del método de pago', 'প্রদানের পদ্ধতি সেটিংস', 'Méthode de paiement'],
            [17, 'role', 'Role', 'Papel', 'ভূমিকা', 'Rôle'],
            [17, 'base_group', 'Base Group', 'Grupo base', 'বেস গ্রুপ', 'Groupe de base'],
            [17, 'base_setup', 'Base Setup', 'Configuración de la base', 'বেস সেটআপ', 'Configuration de base'],
            [17, 'academic_year', 'Academic Year', 'Año académico', 'শিক্ষাবর্ষ', 'Année académique'],
            [17, 'session', 'Academic Year', 'Academic Year', 'সেশন', 'Academic Year'],
            [17, 'holiday', 'Holiday', 'Vacaciones', 'ছুটির দিন', 'Vacances'],
            [17, 'sms_settings', 'Sms Settings', 'Configuración de SMS', 'এসএমএস সেটিংস', 'Paramètres Sms'],
            [17, 'language_settings', 'Language Settings', 'Configuraciones de idioma', 'ভাষা সেটিংস', 'Paramètres de langue'],
            [17, 'backup_settings', 'Backup', 'Apoyo', 'ব্যাকআপ', 'Sauvegarde'],
            [17, 'select_language', 'Select Language', 'Seleccione el idioma', 'ভাষা নির্বাচন কর', 'Choisir la langue'],
            [17, 'native', 'Native', 'Nativo', 'স্থানীয়', 'Originaire de'],
            [17, 'universal', 'Universal', 'Universal', 'সার্বজনীন', 'Universel'],
            [17, 'make_default', 'Make Default', 'Hacer por defecto', 'ডিফল্ট করা', 'Faire défaut'],
            [17, 'setup', 'Setup', 'Preparar', 'সেটআপ', 'Installer'],
            [17, 'change_logo', 'Change Logo', 'Cambiar Logo', 'লোগো পরিবর্তন করুন', 'Changer le logo'],
            [17, 'change_fav', 'Change Favicon', 'Cambiar Favicon', 'ফ্যাভিকন পরিবর্তন করুন', 'Changer de favicon'],
            [17, 'upload', 'Upload', 'Subir', 'আপলোড', 'Télécharger'],
            [17, 'school_name', 'School Name', 'Nombre de la escuela', 'স্কুলের নাম', 'Nom de lécole'],
            [17, 'school_code', 'School Code', 'Código escolar', 'স্কুল কোড', 'Code détablissement'],
            [17, 'language', 'Language', 'Idioma', 'ভাষা', 'La langue'],
            [17, 'date_format', 'Date Format', 'Formato de fecha', 'তারিখ বিন্যাস', 'Format de date'],
            [17, 'currency', 'Currency', 'Moneda', 'মুদ্রা', 'Devise'],
            [17, 'symbol', 'Symbol', 'Símbolo', 'প্রতীক', 'symbole'],
            [17, 'sand', 'Sand', 'Arena', 'বালি', 'Le sable'],
            [17, 'smtp', 'SMTP', 'SMTP', 'এসএমটিপি', 'SMTP'],
            [17, 'from_name', 'From Name', 'De Nombre', 'নাম থেকে', 'De nom'],
            [17, 'from_email', 'From Email', 'Desde el e-mail', 'ইমেল থেকে', 'De lemail'],
            [17, 'server', 'Server', 'Servidor', 'সার্ভার', 'Serveur'],
            [17, 'port', 'Port', 'Puerto', 'বন্দর', 'Port'],
            [17, 'security', 'Security', 'Seguridad', 'নিরাপত্তা', 'Sécurité'],
            [17, 'select_a_payment_gateway', 'Select a Payment Gateway', 'Seleccione una pasarela de pago', 'পেমেন্ট গেটওয়ে নির্বাচন করুন', 'Sélectionnez une passerelle de paiement'],
            [17, 'checked', 'Checked', 'Comprobado', 'সংযত', 'Vérifié'],
            [17, 'paypal', 'Paypal', 'Paypal', 'পেপ্যাল', 'Pay Pal'],
            [17, 'stripe', 'Stripe', 'Raya', 'ডোরা', 'Bande'],
            [17, 'razorpay', 'Razorpay', 'Razorpay', 'রেজারপে', 'Razorpay'],
            [17, 'payUMoney', 'PayUMoney', 'PayUMoney', 'পেইউমনি', 'PayUMoney'],
            [17, 'signature', 'Signature', 'Firma', 'স্বাক্ষর', 'Signature'],
            [17, 'client_id', 'Client ID', 'Identificación del cliente', 'ক্লায়েন্ট আইডি', 'identité du client'],
            [17, 'secret_id', 'Secret ID', 'ID secreta', 'সিক্রেট আইডি', 'ID secret'],
            [17, 'stripe_api_secret_key', 'Stripe API Secret Key', 'Stripe API Secret Key', 'স্ট্রিপ এপিআই সিক্রেট কী', 'Clé secrète de lAPI de bande'],
            [17, 'stripe_publisher_key', 'Stripe Publishable Key', 'Stripe Publishable Key', 'স্ট্রাইপ প্রকাশযোগ্য কী', 'Raie Clé Publiable'],
            [17, 'pay_u_money_key', 'PayU Money Key', 'PayU Money Key', 'পেইউমনি কী', 'Clé PayU Money'],
            [17, 'pay_u_money_salt', 'PayU Money Salt', 'PayU Money Salt', 'পেইউ মানি লবণ', 'PayU Money Salt'],
            [17, 'role_permission', 'Role Permission', 'Permiso de rol', 'ভূমিকা অনুমতি', 'Permission de rôle'],
            [17, 'assign_permission', 'Assign Permission', 'Asignar permiso', 'অনুমতি বরাদ্দ করুন', 'Attribuer une autorisation'],
            [17, 'label', 'Label', 'Etiqueta', 'লেবেল', 'Étiquette'],
            [17, 'base', 'Base', 'Base', 'ভিত্তি', 'Base'],
            [17, 'year_title', 'Year Title', 'Título del año', 'বছরের শিরোনাম', 'Titre de lannée'],
            [17, 'starting_date', 'Starting Date', 'Fecha de inicio', 'শুরু তারিখ', 'Date de début'],
            [17, 'ending_date', 'Ending Date', 'Fecha de finalización', 'সমাপ্তির তারিখ', 'Fin'],
            [17, 'select_a_SMS_service', 'Select a SMS Service', 'Seleccione un servicio de SMS', 'একটি এসএমএস পরিষেবা নির্বাচন করুন', 'Sélectionnez un service SMS'],
            [17, 'clickatell', 'Clickatell', 'Clickatell', 'ক্লিক স্যাটেলাইট', 'Clickatell'],
            [17, 'settings', 'Settings', 'Ajustes', 'সেটিংস', 'Réglages'],
            [17, 'chat', 'Chat', 'Chat', 'চ্যাট', 'Chat'],
            [17, 'chatting', 'Chatting', 'Chatting', 'চ্যাটিং', 'Chatting'],
            [17, 'box', 'Box', 'Box', 'বাক্স', 'Box'],
            [17, 'invitation', 'Invitation', 'Invitation', 'আমন্ত্রণ', 'Invitation'],
            [17, 'blocked', 'Blocked', 'Blocked', 'অবরুদ্ধ', 'Blocked'],
            [17, 'you', 'You', 'You', 'আপনি', 'You'],
            [17, 'requests', 'Requests', 'Requests', 'অনুরোধ', 'Requests'],
            [17, 'request', 'Request', 'Request', 'অনুরোধ', 'Request'],
            [17, 'connect', 'Connect', 'Connect', 'সংযোগ করুন', 'Connect'],
            [17, 'people', 'People', 'People', 'মানুষ', 'People'],
            [17, 'connection', 'Connection', 'Connection', 'সংযোগ', 'Connection'],
            [17, 'connections', 'Connections', 'Connections', 'সংযোগ', 'Connections'],
            [17, 'connected', 'Connected', 'Connected', 'সংযুক্ত', 'Connected'],
            [17, 'unblock', 'Unblock', 'Unblock', 'অবরোধ মুক্ত করুন', 'Unblock'],
            [17, 'block', 'Block', 'Block', 'ব্লক', 'Block'],
            [17, 'can_teacher_chat_with_parents', 'Can Teacher Chat With Parents', 'Can Teacher Chat With Parents', 'শিক্ষক পিতামাতার সাথে চ্যাট করতে পারেন', 'Can Teacher Chat With Parents'],
            [17, 'can_student_chat_with_admin_accounts', 'Can Student Chat With Admin, Accounts', 'Can Student Chat With Admin, Accounts', 'প্রশাসক, অ্যাকাউন্টগুলির সাথে শিক্ষার্থীরা চ্যাট করতে পারে', 'Can Student Chat With Admin, Accounts'],
            [17, 'admin_can_chat_without_invitation', 'Admin Can Chat Without Invitation', 'Admin Can Chat Without Invitation', 'অ্যাডমিন আমন্ত্রণ ছাড়াই চ্যাট করতে পারেন', 'Admin Can Chat Without Invitation'],
            [17, 'open_chat_system', 'Open Chat System', 'Open Chat System', 'ওপেন চ্যাট সিস্টেম', 'Open Chat System'],
            [17, 'requirement', 'Requirement', 'Requirement', 'প্রয়োজনীয়তা', 'Requirement'],
            [17, 'required', 'Required', 'Required', 'প্রয়োজনীয়', 'Required'],
            [17, 'old', 'Old', 'Old', 'পুরাতন', 'Old'],
            [17, 'can_upload_file', 'Can Upload File', 'Can Upload File', 'ফাইল আপলোড করতে পারেন', 'Can Upload File'],
            [17, 'upload_file_limit', 'Upload File Limit', 'Upload File Limit', 'ফাইল সীমা আপলোড করুন', 'Upload File Limit'],
            [17, 'mb', 'Megabyte', 'Megabyte', 'মেগাবাইট', 'Megabyte'],
            [17, 'can', 'Can', 'Can', 'মেগাবাইট', 'Can'],
            [17, 'can_make_group', 'Can Make Group', 'Can Make Group', 'গ্রুপ তৈরি করতে পারে', 'Can Make Group'],
            [17, 'can_staff_or_teacher_ban_tudent', 'Can Staff or Teacher Ban Student', 'Can Staff or Teacher Ban Student', 'স্টাফ বা শিক্ষক নিষিদ্ধ ছাত্র', 'Can Staff or Teacher Ban Student'],
            [17, 'teacher_can_pinned_top_message', 'Teacher Can Pinned Top Message', 'Teacher Can Pinned Top Message', 'শিক্ষক শীর্ষ বার্তা পিন করতে পারেন', 'Teacher Can Pinned Top Message'],
            [17, 'conversition', 'Conversition', 'Conversition', 'কথোপকথন', 'Conversition'],
            [17, 'this', 'This', 'This', 'এই', 'This'],
            [17, 'load_more', 'Load More', 'Load More', 'আর ঢুকাও', 'Load More'],
            [17, 'attachment', 'Attachment', 'Attachment', 'সংযুক্তি', 'Attachment'],
            [17, 'forwarded_message', 'Forwarded Message', 'Forwarded Message', 'প্রেরণকৃত বার্তা', 'Forwarded Message'],
            [17, 'forward', 'Forward', 'Forward', 'ফরোয়ার্ড', 'Forward'],
            [17, 'quote', 'Quote', 'Quote', 'উদ্ধৃতি', 'Quote'],
            [17, 'replying', 'Replying', 'Replying', 'উত্তর', 'Replying'],
            [17, 'keywords', 'Keywords', 'Keywords', 'কীওয়ার্ডস', 'Keywords'],
            [17, 'media_files', 'Media Files', 'Media Files', 'মিডিয়া ফাইল', 'Media Files'],
            [17, 'showing', 'Showing', 'Showing', 'দেখাচ্ছে', 'Showing'],
            [17, 'your_voice_is_recording', 'Your Voice Is Recording', 'Your Voice Is Recording', 'আপনার ভয়েস রেকর্ডিং হয়', 'Your Voice Is Recording'],
            [17, 'moderate', 'Moderate', 'Moderate', 'মাঝারি', 'Moderate'],
            [17, 'remove_read_only', 'Remove Read Only', 'Remove Read Only', 'কেবল পঠনযোগ্য সরান', 'Remove Read Only'],
            [17, 'mark_as_read_only', 'Mark As Read Only', 'Mark As Read Only', 'কেবলমাত্র পঠন হিসাবে চিহ্নিত করুন', 'Mark As Read Only'],
            [17, 'write_something_Optional', 'Write something (Optional)', 'Write something (Optional)', 'কিছু লিখুন (ঐচ্ছিক)', 'Write something (Optional)'],
            [17, 'away', 'Away', 'Away', 'দূরে', 'Away'],
            [17, 'busy', 'Busy', 'Busy', 'ব্যস্ত', 'Busy'],
            [17, 'someone', 'Someone', 'Someone', 'কেউ', 'Someone'],
            [17, 'is_typing', 'Is Typing', 'Is Typing', 'টাইপিং হয়', 'Is Typing'],
            [17, 'you_are_invited_in_new_group', 'You are invited in new group', 'You are invited in new group', 'আপনাকে নতুন দলে আমন্ত্রিত করা হয়েছে', 'You are invited in new group'],
            [17, 'new_message_in_this_group', 'New message in this group', 'New message in this group', 'এই গ্রুপে নতুন বার্তা', 'New message in this group'],
            [17, 'twilio', 'Twilio', 'Twilio', 'টিভিলিও', 'Twilio'],
            [17, 'api', 'API', 'API', 'এপিআই', 'API'],
            [17, 'sid', 'SID', 'SID', 'এসআইডি', 'SID'],
            [18, 'front_end_settings', 'Front End Settings', 'Configuraciones frontales', 'সম্মুখ সমাপ্তি সেটিংস', 'Paramètres frontaux'],
            [18, 'navigation', 'Navigation', 'Navigation', 'নেভিগেশন', 'Navigation'],
            [18, 'left', 'Left', 'Left', 'বাম', 'Left'],
            [18, 'right', 'Right', 'Right', 'ডান', 'Right'],
            [18, 'open_in_a_new_tab', 'Open In a New Tab', 'Open In a New Tab', 'একটি নতুন ট্যাবে খুলুন', 'Open In a New Tab'],
            [18, 'add_news', 'Add News', 'Añadir noticias', 'সংবাদ যুক্ত করুন', 'Ajouter des nouvelles'],
            [18, 'news', 'News', 'Noticias', 'খবর', 'Nouvelles'],
            [18, 'news_list', 'News List', 'Lista de noticias', 'সংবাদ তালিকা', 'Liste de nouvelles'],
            [18, 'image', 'Image', 'Imagen', 'ভাবমূর্তি', 'Image'],
            [18, 'publication_date', 'Publication Date', 'Fecha de publicación', 'প্রকাশনার তারিখ', 'Date de publication'],
            [18, 'add_testimonial', 'Add Testimonial', 'Añadir Testimonial', 'প্রশংসাপত্র যোগ করুন', 'Ajouter un témoignage'],
            [18, 'testimonial', 'Testimonial', 'Testimonial', 'এজাহারনামা', 'Témoignage'],
            [18, 'institution_name', 'Institution Name', 'Nombre de la Institución', 'প্রতিষ্ঠানের নাম', 'nom de linstitution'],
            [18, 'institute', 'Institute', 'Institute', 'ইনস্টিটিউট', 'Institute'],
            [18, 'location', 'Location', 'Ubicación', 'অবস্থান', 'Emplacement'],
            [18, 'front_settings', 'Front Settings', 'Ajustes frontales', 'সামনের সেটিংস', 'Paramètres avant'],
            [19, 'my_profile', 'My Profile', 'Mi perfil', 'আমার প্রোফাইল', 'Mon profil'],
            [19, 'fees', 'Fees', 'Matrícula', 'ফি', 'Honoraires'],
            [19, 'pay_fees', 'Pay Fees', 'Cuotas de pago', 'ফি পরিশোধ', 'Payer les frais'],
            [19, 'download_center', 'Download Center', 'Centro de descargas', 'ডাউনলোড কেন্দ্র', 'centre de téléchargement'],
            [19, 'student_study_material', 'Study Materials', 'Materiales de estudio', 'অধ্যয়ন উপকরণ', 'Matériel détudes'],
            [19, 'examinations', 'Examinations', 'Exámenes', 'পরীক্ষায়', 'Examens'],
            [19, 'rule', 'Rule', 'Rule', 'নিয়ম', 'Rule'],
            [19, 'setup', 'Setup', 'Setup', 'সেটআপ', 'Setup'],
            [19, 'result', 'Result', 'resultado', 'ফলাফল', 'résultat'],
            [19, 'active_exams', 'Active Exams', 'Exámenes activos', 'সক্রিয় পরীক্ষা', 'Examens actifs'],
            [19, 'book_issue', 'Book issued', 'Libro emitido', 'বই জারি', 'Livre publié'],
            [19, 'my_children', 'My Children', 'Mis hijos', 'আমার শিশু', 'Mes enfants'],
            [19, 'exam_result', 'Exam Result', 'Resultado del examen', 'পরীক্ষার ফলাফল', 'Résultat déxamen'],
            [19, 'teacher_list', 'Teacher list', 'Lista de profesores', 'শিক্ষকের তালিকা', 'Liste des enseignants'],
            [19, 'inserted_message', 'Operation Successfully', 'Insertado con éxito', 'সফলভাবে অপারেশন', 'Inséré avec succès'],
            [19, 'updated_message', 'Updated Successfully', 'Actualizado exitosamente', 'সফলভাবে আপডেট হয়েছে', 'Mis à jour avec succés'],
            [19, 'deleted_message', 'Deleted Successfully', 'Borrado exitosamente', 'সফলভাবে মোছা হয়েছে', 'Supprimé avec succès'],
            [19, 'inactive_message', 'Inactivated Successfully', 'Inactivado con éxito', 'সফলভাবে নিষ্ক্রিয় করা হয়েছে', 'Inactivé avec succès'],
            [19, 'active_message', 'Activated Successfully', 'Activado con éxito', 'সফলভাবে সক্রিয় হয়েছে', 'Activé avec succès'],
            [19, 'backup_message', 'Backup Successfully', 'Copia de seguridad con éxito', 'ব্যাকআপ সফলভাবে', 'Sauvegarde réussie'],
            [19, 'restore_message', 'Restore Successfully', 'Restaurar con éxito', 'সফলভাবে পুনরুদ্ধার করুন', 'Restaurer avec succès'],
            [19, 'not_found_message', 'Ops! Data not Found', 'Ops! Datos no encontrados', 'অপস! তথ্য পাওয়া যায়নি', 'Ops! Données non trouvées'],
            [19, 'error_message', 'Ops! Something went wrong, please try again', 'Ops! Algo salió mal. Por favor, vuelva a intentarlo', 'অপস! কিছু ভুল হয়েছে আবার চেষ্টা করুন', 'Ops! Une erreur sest produite. Veuillez réessayer'],
            [19, 'front_cms', 'Front cms', 'Frente cms', 'সামনের সেমি', 'Cms avant'],
            [19, 'update_system', 'Update System', 'Sistema de actualización', 'আপডেট সিস্টেম', 'Système de mise à jour'],
            [19, 'about_&_update', 'About & Update', 'About & Update', 'সম্পর্কে এবং আপডেট', 'About & Update'],
            [19, 'System_Status', 'System Status', 'Estado del sistema', 'সিস্টেমের অবস্থা', 'État du système'],
            [19, 'Upgrade', 'Upgrade', 'Mejorar', 'আপগ্রেড করুন', 'Améliorer'],
            [19, 'Version', 'Version', 'Versión', 'সংস্করণ', 'Version'],
            [19, 'Existing', 'Existing', 'Existente', 'বর্তমান', 'Existant'],
            [19, 'Available', 'Available', 'Disponible', 'সহজলভ্য', 'Disponible'],
            [19, 'Alert', 'Alert', 'Alerta', 'সতর্ক', 'Alerte'],
            [19, 'New_Features', 'New Features', 'Nuevas características', 'নতুন বৈশিষ্ট', 'Nouvelles fonctionnalités'],
            [19, 'copyright_text', 'Copyright Text', 'Texto de copyright', 'কপিরাইট পাঠ্য', 'Texte de copyright'],
            [2, 'grade_point', 'Grade Point', 'Grade Point', 'গ্রেড পয়েন্ট', 'Grade Point'],
            [2, 'without_additional', 'Without Additional', 'Without Additional', 'অতিরিক্ত ছাড়া', 'Without Additional'],
            [2, 'additional_subject', 'Additional Subject', 'Additional Subject', 'অতিরিক্ত বিষয়', 'Additional Subject'],
            [2, 'without', 'Without', 'Without', 'বিনা', 'Without'],
            [2, 'letter', 'Letter', 'Letter', 'অক্ষর', 'Letter'],
            [2, 'point', 'Point', 'Point', 'পয়েন্ট', 'Point'],
            [2, 'gpa_above', 'GPA Above', 'GPA above', 'উপরে জিপিএ', 'GPA above'],
            [2, 'date_of_publication_of_result', 'Date of Publication of Result', 'Date of Publication of Result', 'ফলাফল প্রকাশের তারিখ', 'Date of Publication of Result'],
            [2, 'controller', 'Controller', 'Controller', 'নিয়ামক', 'Controller'],
            [2, 'class_report_for_class', 'Class Report for class', 'Class Report for class', 'ক্লাসের জন্য ক্লাস রিপোর্ট', 'Class Report for class'],
            [2, 'history', 'History', 'History', 'ইতিহাস', 'History'],
            [2, 'change_password', 'Change Password', 'Change Password', 'পাসওয়ার্ড পরিবর্তন করুন', 'Change Password'],
            [2, 'course_heading', 'Course Heading', 'Course Heading', 'কোর্স শিরোনাম', 'Course Heading'],
            [2, 'course_details_heading', 'Course Details Heading', 'Course Details Heading', 'কোর্স বিশদ শিরোনাম', 'Course Details Heading'],
            [2, 'news_heading', 'News Heading', 'News Heading', 'সংবাদ শিরোনাম', 'News Heading'],
            [2, 'subject_attendance_report', 'Subject Attendance Report', 'Subject Attendance Report', 'বিষয় উপস্থিতি রিপোর্ট', 'Subject Attendance Report'],
            [2, 'subject_wise_attendance_report', 'Subject Wise Attendance Report', 'Subject Wise  Attendance Report', 'বিষয় উপস্থিতি রিপোর্ট', 'Subject Wise  Attendance Report'],
            [2, 'ltl', 'LTL', 'LTL', 'এলটিএল', 'LTL'],
            [2, 'rtl', 'RTL', 'RTL', 'আরটিএল', 'RTL'],
            [2, 'alignment', 'Alignment', 'Alignment', 'শ্রেণীবিন্যাস', 'Alignment'],
            [2, 'invoice', 'Invoice', 'Invoice', 'চালান', 'Invoice'],
            [2, 'new_client_information', 'New Client Information', 'New Client Information', 'নতুন ক্লায়েন্ট তথ্য', 'New Client Information'],
            [2, 'made', 'Made', 'Made', 'প্রণীত', 'Made'],
            [2, 'exam', 'Exam', 'Exam', 'পরীক্ষা', 'Exam'],
            [2, 'final', 'Final', 'Final', 'ফাইনাল', 'Final'],
            [2, 'contribution', 'Contribution', 'Contribution', 'অবদান', 'Contribution'],
            [2, 'phone_number', 'Phone Number', 'Phone Number', 'ফোন নম্বর', 'Phone Number'],
            [2, 'transport_and_dormitory_details', 'Transport and Dormitory Details', 'Transport and Dormitory Details', 'পরিবহন এবং ছাত্রাবাসের বিশদ', 'Transport and Dormitory Details'],
            [2, 'driver_phone_number', 'Driver Phone Number', 'Driver Phone Number', 'ড্রাইভার ফোন নম্বর', 'Driver Phone Number'],
            [2, 'national_identification_number', 'National Identification Number', 'National Identification Number', 'জাতীয় সনাক্তকারী নম্বর', 'National Identification Number'],
            [2, 'local_identification_number', 'Local Identification Number', 'Local Identification Number', 'স্থানীয় পরিচয় নম্বর', 'Local Identification Number'],
            [2, 'UBC56987', 'UBC56987', 'UBC56987', 'ইউবিসি 56987', 'UBC56987'],
            [2, 'incompleted', 'Incompleted', 'Incompleted', 'অসম্পূর্ণ', 'Incompleted'],
            [2, 'room_name', 'Room Name', 'Room Name', 'রুমের নাম', 'Room Name'],
            [2, 'class_period', 'Class Period', 'Class Period', 'ক্লাসের সময়সীমা', 'Class Period'],
            [2, 'paystack', 'Paystack', 'Paystack', 'পেস্ট্যাক', 'Paystack'],
            [2, 'paystack_note', 'Paystack Note', 'Paystack Note', 'পেস্ট্যাক নোট', 'Paystack Note'],
            [2, 'update_news_heading_section', 'Update News Heading Section', 'Update News Heading Section', 'আপডেট শিরোনাম বিভাগ', 'Update News Heading Section'],
            [2, 'membership', 'Membership', 'Membership', 'সদস্যতা', 'Membership'],
            [2, 'purchase_receipt', 'Purchase Receipt', 'Purchase Receipt', 'কেনার রশিদ', 'Purchase Receipt'],
            [2, 'bill_to', 'Bill To', 'Bill To', 'বিল টু', 'Bill To'],
            [2, 'sell_receipt', 'Sell Receipt', 'Sell Receipt', 'রসিদ বিক্রি করুন', 'Sell Receipt'],
            [2, 'sale_to', 'Sale To', 'Sale To', 'বিক্রয়', 'Sale To'],
            [2, 'sell_date', 'Sell Date', 'Sell Date', 'তারিখ বিক্রয়', 'Sell Date'],
            [2, 'item_sale', 'Item Sale', 'Item Sale', 'আইটেম বিক্রয়', 'Item Sale'],
            [2, 'sell_price', 'Sell Price', 'Sell Price', 'বিক্রয় মূল্য', 'Sell Price'],
            [2, 'contarct_type', 'Contarct Type', 'Contarct Type', 'সংযুক্তি প্রকার', 'Contarct Type'],
            [2, 'work_experience', 'Work Experience', 'Work Experience', 'কর্মদক্ষতা', 'Work Experience'],
            [2, 'mode_of_payment', 'Mode of Payment', 'Mode of Payment', 'পেমেন্ট মোড', 'Mode of Payment'],
            [2, 'no_payroll_data', 'No Payroll Data', 'No Payroll Data', 'কোনও পেওরোল ডেটা নেই', 'No Payroll Data'],
            [2, 'not_leaves_data', 'Not Leaves Data', 'Not Leaves Data', 'পাতাগুলি নেই', 'Not Leaves Data'],
            [2, 'joining_letter', 'Joining Letter', 'Joining Letter', 'চিঠি যোগ দিচ্ছেন', 'Joining Letter'],
            [2, 'student_information', 'Student Info', 'Información del estudiante', 'শিক্ষার্থীদের তথ্য', 'Info étudiant'],
           
            [2, 'student_admission', 'Student Admission', 'Admisión de estudiantes', 'ছাত্র ভর্তি', 'Admission des étudiants'],
            [2, 'student_export', 'Student Export', 'Student Export', 'রফতানি', 'Student Export'],
            [2, 'import', 'Import', 'Importar', 'আমদানি', 'Importation'],
            [2, 'personal', 'Personal', 'Personal', 'ব্যক্তিগত', 'Personnel'],
            [2, 'info', 'Info', 'Información', 'তথ্য', 'Info'],
            [2, 'roll', 'Roll', 'Rodar', 'রোল', 'Rouleau'],
            [2, 'first', 'First', 'primero', 'প্রথম', 'Premier'],
            [2, 'last', 'Last', 'Último', 'গত', 'Dernier'],
            [2, 'religion', 'Religion', 'Religión', 'ধর্ম', 'Religion'],
            [2, 'caste', 'Caste', 'Casta', 'জাত', 'Caste'],
            [2, 'category', 'Category', 'Categoría', 'বিভাগ', 'Catégorie'],
            
            [2, 'height', 'Height', 'Altura', 'উচ্চতা', 'la taille'],
            [2, 'width', 'Width', 'Width', 'প্রস্থ', 'Width'],
            [2, 'full', 'Full', 'Full', 'সম্পূর্ণ', 'Full'],
            [2, 'half', 'Half', 'Half', 'অর্ধেক', 'Half'],
            [2, 'one_thired', 'One Thired', 'One Thired', 'প্রস্থ', 'One Thired'],
            [2, 'one_fourth', 'One Fourth', 'One Fourth', 'এক চতুর্থাংশ', 'One Fourth'],
            [2, 'Weight', 'Weight', 'Peso', 'ওজন', 'Poids'],
            [2, 'applicable_user', 'Applicable User', 'Applicable User', 'প্রযোজ্য ব্যবহারকারী', 'Applicable User'],
            [2, 'page_layout', 'Page Layout', 'Page Layout', 'পৃষ্ঠা বিন্যাস', 'Page Layout'],
            [2, 'round', 'Round', 'Round', 'গোল', 'Round'],
            [2, 'squre', 'Squre', 'Squre', 'বর্গক্ষেত্র', 'Squre'],
            [2, 'layout_spacing', 'Layout Spacing', 'Layout Spacing', 'বিন্যাস ফাঁক', 'Layout Spacing'],
            [2, 'top_space', 'Top Space', 'Top Space', 'শীর্ষ স্থান', 'Top Space'],
            [2, 'bottom_space', 'Bottom Space', 'Bottom Space', 'নীচের স্থান', 'Bottom Space'],
            [2, 'left_space', 'Left Space', 'Left Space', 'বাম স্থান', 'Left Space'],
            [2, 'right_space', 'Right Space', 'Right Space', 'ডান স্থান', 'Right Space'],
            [2, 'horizontal', 'Horizontal', 'Horizontal', 'অনুভূমিক', 'Horizontal'],
            [2, 'vertical', 'Vertical', 'Vertical', 'উল্লম্ব', 'Vertical'],
            [2, 'student_registration_custom_field', 'Student Registration Custom Field', 'Student Registration Custom Field', 'ছাত্র নিবন্ধন কাস্টম ক্ষেত্র', 'Student Registration Custom Field'],
            [2, 'sibling', 'Sibling', 'Hermano', 'সমরূপ', 'Enfant de mêmes parents'],
          
            [2, 'information', 'Information', 'Información', 'তথ্য', 'Information'],
            [2, 'guardian', 'Guardian', 'guardián', 'অভিভাবক', 'Gardien'],
            [2, '&', '&', 'Y', 'এবং', 'Et'],
            [2, 'occupation', 'Occupation', 'Ocupación', 'পেশা', 'Occupation'],
            [2, 'photo', 'Photo', 'Foto', 'ছবি', 'Photo'],
            [2, 'Other', 'Others', 'Otros', 'অন্যান্য', 'Autres'],
            [2, 'relation_with_guardian', 'Relation with Guardian', 'Relación con Guardian', 'অভিভাবকের সাথে সম্পর্ক', 'Relation avec le gardien'],
            [2, 'current', 'Current', 'Corriente', 'বর্তমান', 'Actuel'],
            [2, 'permanent', 'Permanent', 'Permanente', 'স্থায়ী', 'Permanent'],
            [2, 'route_list', 'Route List', 'Lista de rutas', 'রুটের তালিকা', 'Liste des itinéraires'],
            [2, 'driver', 'Driver', 'Conductor', 'চালক', 'Chauffeur'],
            [2, 'room', 'Room', 'Habitación', 'ঘর', 'Pièce'],
            [2, 'national_id', 'National Identity', 'National Identity', 'জাতীয় পরিচয়', 'National Identity'],
            [2, 'local_id', 'Local Identity', 'Local Identity', 'স্থানীয় পরিচয়', 'Local Identity'],
            [2, 'bank', 'Bank', 'Banco', 'ব্যাংক', 'Banque'],
            [2, 'previous_school_details', 'Previous School Details', 'Detalles de la escuela anterior', 'পূর্ববর্তী স্কুলের বিবরণ', 'Détails de lécole précédente'],
            [2, 'additional_notes', 'Additional Notes', 'Notas adicionales', 'অতিরিক্ত নোট', 'Notes complémentaires'],
            [2, 'parents_and_guardian_info', 'PARENTS & GUARDIAN INFO', 'INFORMACIÓN PARA LOS PADRES Y TUTORES', 'অভিভাবক এবং গার্ডিয়ান তথ্য', 'INFO PARENTS ET GARDIENS'],
            [2, 'transport_and_dormitory_info', 'Transport & Dormitory Info', 'Información de transporte y dormitorio', 'পরিবহন এবং ছাত্রাবাসের তথ্য', 'Informations sur le transport et le dortoir'],
            [2, 'document_info', 'Document Info', 'Información del documento', 'নথি তথ্য', 'Informations sur le document'],
            [2, 'document_01_title', 'Document 01 Title', 'Documento 01 Título', 'নথি 01 শিরোনাম', 'Document 01 Titre'],
            [2, 'document_02_title', 'Document 02 Title', 'Documento 02 Titulo', 'দলিল 02 শিরোনাম', 'Document 02 Titre'],
            [2, 'document_03_title', 'Document 03 Title', 'Título del documento 03', 'দলিল 03 শিরোনাম', 'Document 03 Titre'],
            [2, 'document_04_title', 'Document 04 Title', 'Documento 04 Título', 'নথি 04 শিরোনাম', 'Document 04 Titre'],
            [2, 'student_details', 'Student Details', 'Detalles del estudiante', 'শিক্ষার্থীদের বিবরণ', 'Détails de létudiant'],
            [2, 'search_by_name', 'Search By Name', 'Buscar por nombre', 'নাম দ্বারা অনুসন্ধান', 'Rechercher par nom'],
            [2, 'search_by_roll_no', 'Search By Roll No', 'Búsqueda por rollo no', 'রোল নম্বর দ্বারা অনুসন্ধান করুন', 'Recherche par roulement no'],
            [2, 'father_name', 'Fathers Name', 'Nombre del Padre', 'বাবার নাম', 'Le nom du père'],
            [2, 'student_promote', 'Student Promote', 'Estudiante de promoción', 'ছাত্র প্রচার করুন', 'Étudiant promouvoir'],
            [2, 'select_current_session', 'Select Current Academic Year', 'Seleccionar Academic Year', 'বর্তমান সেশন নির্বাচন করুন', 'Sélectionner Academic Year'],
            [2, 'select_current_class', 'Select current Class', 'Seleccione la clase actual', 'বর্তমান ক্লাস নির্বাচন করুন', 'Sélectionnez la classe actuelle'],
            [2, 'select_current_section', 'Select Current section', 'Seleccione la sección actual', 'বর্তমান বিভাগ নির্বাচন করুন', 'Sélectionnez la section actuelle'],
            [2, 'promote_student_in_next_session', 'Promote Student In Next Academic Year', 'Promover estudiante en la próxima sesión', 'পরের সেশনে শিক্ষার্থী প্রচার করুন', 'Promouvoir létudiant à la prochaine session'],
            [2, 'view_academic_performance', 'View Academic Performance', 'Ver rendimiento académico', 'একাডেমিক পারফরম্যান্স দেখুন', 'Voir la performance académique'],
            [2, 'pass', 'Pass', 'Pasar', 'পাস', 'Passer'],
            [2, 'fail', 'Fail', 'Fallar', 'ব্যর্থ', 'Échouer'],
            [2, 'select_promote_session', 'Select Promote Academic Year', 'Seleccione Promover Academic Year', 'সেশন প্রচার করুন নির্বাচন করুন', 'Sélectionnez la session de promotion'],
            [2, 'select_promote_class', 'Select Promote Class', 'Seleccione Promover clase', 'শ্রেণী প্রচার করুন নির্বাচন করুন', 'Sélectionnez Promouvoir la classe'],
            [2, 'the_session_is_required', 'The session is required', 'La sesion es obligatoria', 'অধিবেশন প্রয়োজন', 'La session est obligatoire'],
            [2, 'the_class_is_required', 'The class is required', 'La clase es obligatoria', 'ক্লাস প্রয়োজন', 'Le cours est obligatoire'],
            [2, 'the_section_is_required', 'The section is required', 'La sección es obligatoria.', 'বিভাগটি প্রয়োজনীয়', 'La section est obligatoire'],
            [2, 'select_promote_section', 'Select Promote Section', 'Seleccione la sección de promoción', 'বিভাগ প্রচার করুন নির্বাচন করুন', 'Sélectionnez la section de promotion'],
            [2, 'promote', 'Promote', 'Promover', 'উন্নীত করা', 'Promouvoir'],
            [2, 'student_attendance', 'Student Attendance', 'Asistencia de estudiantes', 'শিক্ষার্থীদের উপস্থিতি', 'Assiduité des étudiants'],
            [2, 'select_class', 'Select Class', 'Seleccionar clase', 'ক্লাস নির্বাচন করুন', 'Sélectionnez une classe'],
            [2, 'attendance', 'Attendance', 'Asistencia', 'উপস্থিতি', 'Présence'],
            [2, 'attendance_already_submitted_as_holiday', 'Attendance Already Submitted As Holiday. You Can Edit Record', 'Asistencia ya enviada como festivo. Puede editar el registro', 'উপস্থিতি ইতিমধ্যে ছুটির দিন হিসাবে জমা দেওয়া হয়েছে। আপনি রেকর্ড সম্পাদনা করতে পারেন', 'Présence déjà soumise à titre de vacances. Vous pouvez modifier lenregistrement'],
            [2, 'attendance_already_submitted', 'Attendance Already Submitted You Can Edit Record', 'La asistencia ya enviada Puede editar el registro', 'উপস্থিতি ইতিমধ্যে জমা দেওয়া আপনি রেকর্ড সম্পাদনা করতে পারেন', 'Présence déjà soumise Vous pouvez modifier la fiche'],
            [2, 'already_submitted', 'Already Submitted', 'Already Submitted', 'ইতিমধ্যে জমা দেওয়া হয়েছে', 'Already Submitted'],
            [2, 'mark_holiday', 'Mark Holiday', 'Mark Holiday', 'মার্ক হলিডে', 'Mark Holiday'],
            [2, 'unmark_holiday', 'Unmark Holiday', 'Unmark Holiday', 'মার্ক হলিডে', 'Unmark Holiday'],
            [2, 'present', 'Present', 'Presente', 'বর্তমান', 'Présent'],
            [2, 'late', 'Late', 'Tarde', 'বিলম্বে', 'En retard'],
            [2, 'absent', 'Absent', 'Ausente', 'অনুপস্থিত', 'Absent'],
            [2, 'half_day', 'Half Day', 'Medio día', 'অর্ধেক দিন', 'Demi-journée'],
            [2, 'add_note_here', 'Add Note Here', 'Añadir nota aquí', 'এখানে নোট যুক্ত করুন', 'Ajouter une note ici'],
            [2, 'error', 'Error', 'Error', 'ত্রুটি', 'Erreur'],
            [2, 'student_attendance_report', 'Student Attendance Report', 'Informe de asistencia del estudiante', 'ছাত্র উপস্থিতি রিপোর্ট', 'Rapport de présence des étudiants'],
            [2, 'january', 'January', 'enero', 'জানুয়ারী', 'janvier'],
            [2, 'february', 'February', 'febrero', 'ফেব্রুয়ারি', 'février'],
            [2, 'march', 'March', 'marzo', 'মার্চ', 'Mars'],
            [2, 'april', 'April', 'abril', 'এপ্রিল', 'avril'],
            [2, 'may', 'May', 'Mayo', 'মে', 'Peut'],
            [2, 'june', 'June', 'junio', 'জুন', 'juin'],
            [2, 'july', 'July', 'julio', 'জুলাই', 'juillet'],
            [2, 'august', 'August', 'agosto', 'অগাস্ট', 'août'],
            [2, 'september', 'September', 'septiembre', 'সেপ্টেম্বর', 'septembre'],
            [2, 'october', 'October', 'octubre', 'অক্টোবর', 'octobre'],
            [2, 'november', 'November', 'noviembre', 'নভেম্বর', 'novembre'],
            [2, 'december', 'December', 'diciembre', 'ডিসেম্বর', 'décembre'],
            [2, 'select_month', 'Select Month', 'Seleccione mes', 'মাস নির্বাচন করুন', 'Sélectionnez un mois'],
            [2, 'select_year', 'Select Year', 'Seleccione el año', 'বছর নির্বাচন করুন', 'Sélectionnez lannée'],
            [2, 'student_category', 'Student Category', 'Categoría de estudiante', 'ছাত্র বিভাগ', 'Catégorie détudiant'],
            [2, 'student_category_list', 'Student Category List', 'Lista de categorías de estudiantes', 'শিক্ষার্থী বিভাগ তালিকা', 'Liste des catégories détudiants'],
            [2, 'student_group', 'Student Group', 'Grupo de estudiantes', 'ছাত্র দল', 'Groupe détudiants'],
            [2, 'group', 'Group', 'Grupo', 'গ্রুপ', 'Groupe'],
            [2, 'disabled_student', 'Disabled Students', 'Estudiantes discapacitados', 'প্রতিবন্ধী শিক্ষার্থীরা', 'Etudiants handicapés'],
            [2, 'student_list', 'Student List', 'Lista de estudiantes', 'ছাত্র তালিকা', 'Liste des étudiants'],
            [2, 'birth_certificate', 'Birth Certificate', 'Certificado de nacimiento', 'জন্ম সনদ', 'Certificat de naissance'],
            [2, 'student_edit', 'Student Edit', 'Estudiante Editar', 'ছাত্র সম্পাদনা', 'Étudiant modifier'],
            [2, 'in', 'In', 'En', 'ভিতরে', 'Dans'],
            [2, 'kg', 'KG', 'KG', 'কেজি', 'KG'],
            [2, 'add_parent', 'Add Parent', 'Añadir padre', 'প্যারেন্ট যোগ করুন', 'Ajouter un parent'],
            [2, 'update_information', 'Update information', 'Actualizar información', 'হালনাগাদ তথ্য', 'Mettre à jour les informations'],
            [2, 'siblings', 'Siblings', 'Hermanos', 'ভাইবোন', 'Frères et sœurs'],
            [2, 'guardian_name', 'Guardians Name', 'Nombre del guardián', 'অভিভাবকদের নাম', 'Nom du gardien'],
            [2, 'guardian_email', 'Guardians Email', 'Email del guardián', 'অভিভাবকরা ইমেল', 'Email du gardien'],
            [2, 'guardian_phone', 'Guardians Phone', 'Teléfono del guardián', 'অভিভাবকরা ফোন', 'Téléphone du gardien'],
            [2, 'guardian_registration_message', 'Guardian Registration Message', 'Guardian Registration Message', 'অভিভাবক নিবন্ধনের বার্তা', 'Guardian Registration Message'],
            [2, 'guardian_occupation', 'Guardian Occupation', 'Ocupación Guardián', 'অভিভাবক পেশা', 'Profession de gardien'],
            [2, 'guardian_address', 'Guardian Address', 'Dirección del tutor', 'অভিভাবক ঠিকানা', 'Adresse du gardien'],
            [2, 'student_address_info', 'Student Address Info', 'Información de la dirección del estudiante', 'শিক্ষার্থী ঠিকানা তথ্য', 'Adresse de l\'étudiant'],
            [2, 'current_address', 'Current Address', 'Direccion actual', 'বর্তমান ঠিকানা', 'Adresse actuelle'],
            [2, 'permanent_address', 'Permanent Address', 'dirección permanente', 'স্থায়ী ঠিকানা', 'Adresse permanente'],
            [2, 'vehicle_number', 'Vehicle Number', 'Número de vehículo', 'যানবাহন নম্বর', 'Numéro de véhicule'],
            [2, 'driver_name', 'Driver Name', 'Nombre del conductor', 'ড্রাইভারের নাম', 'Nom du conducteur'],
            [2, 'bank_name', 'Bank Name', 'Nombre del banco', 'ব্যাংকের নাম', 'Nom de banque'],
            [2, 'update_student', 'update student', 'actualizar estudiante', 'আপডেট ছাত্র', 'mise à jour de létudiant'],
            [2, 'remove', 'Remove', 'retirar', 'অপসারণ', 'Retirer'],
            [2, 'are_you', 'Are you sure to remove siblings?', '¿Estás seguro de eliminar a los hermanos?', 'আপনি কি ভাইবোনদের সরানোর বিষয়ে নিশ্চিত?', 'Êtes-vous sûr de vouloir supprimer vos frères et soeurs?'],
            [2, 'download_sample_file', 'Download Sample File', 'Descargar archivo de muestra', 'নমুনা ফাইলটি ডাউনলোড করুন', 'Télécharger un exemple de fichier'],
            [2, 'other_documents', 'Other Documents', 'Other Documents', 'অন্যান্য কাগজপত্র', 'Other Documents'],
            [2, 'documents', 'Documents', 'Documents', 'কাগজপত্র', 'Documents'],
            [2, 'resume', 'Resume', 'Resume', 'জীবনবৃত্তান্ত', 'Resume'],
            [2, 'summery', 'Summery', 'Summery', 'গ্রীষ্মের বৈশিষ্ট্যপূর্ণ', 'Summery'],
            [2, 'academic_records', 'Academic Records', 'Academic Records', 'একাডেমিক রেকর্ড', 'Academic Records'],
            [2, 'chairman_of_the_examination_board', 'Chairman of the Examination Board', 'Chairman of the Examination Board', 'পরীক্ষা বোর্ডের চেয়ারম্যান', 'Chairman of the Examination Board'],
            [2, 'head_of_students_affairs', 'Head of Students Affairs', 'Head of Students Affairs', 'ছাত্র বিষয়ক প্রধান', 'Head of Students Affairs'],
            [2, 'merit', 'Merit', 'Merit', 'যোগ্যতা', 'Merit'],
            [2, 'merit_list', 'Merit List', 'Merit List', 'মেধা তালিকা', 'Merit List'],
            [2, 'academic', 'Academic', 'Academic', 'একাডেমিক', 'Academic'],
            [2, 'staring', 'Staring', 'Staring', 'অনিমেষনেত্রে', 'Staring'],
            [2, 'ending', 'Ending', 'Ending', 'শেষ', 'Ending'],
            [2, 'evalution', 'Evalution', 'Evalution', 'মূল্যায়ন', 'Evalution'],
            [2, 'marks_sheet_of', 'Marks Sheet of', 'Marks Sheet of', 'পত্রকটি চিহ্নিত করে', 'Marks Sheet of'],
            [2, 'highest_marks', 'Highest Marks', 'Highest Marks', 'সর্বোচ্চ নম্বর', 'Highest Marks'],
            [2, 'letter_grade', 'Letter Grade', 'Letter Grade', 'লেটার গ্রেড', 'Letter Grade'],
            [20, 'point1', 'Your CSV data should be in the format download file. The first line of your CSV file should be the column headers as in the table example. Also make sure that your file is UTF-8 to avoid unnecessary encoding problems.', 'Sus datos CSV deben estar en el archivo de descarga de formato. La primera línea de su archivo CSV debe ser los encabezados de columna como en el ejemplo de la tabla. También asegúrese de que su archivo sea UTF-8 para evitar problemas de codificación innecesarios.', 'আপনার সিএসভি ডেটা ফর্ম্যাট ডাউনলোড ফাইলে থাকা উচিত। আপনার সিএসভি ফাইলের প্রথম লাইনটি সারণীর উদাহরণ হিসাবে কলাম শিরোনাম হওয়া উচিত। অপ্রয়োজনীয় এনকোডিংয়ের সমস্যা এড়াতে আপনার ফাইলটি ইউটিএফ -8 রয়েছে তাও নিশ্চিত করুন।', 'Your CSV data should be in the format download file. The first line of your CSV file should be the column headers as in the table example. Also make sure that your file is UTF-8 to avoid unnecessary encoding problems.'],
            [20, 'point2', 'If the column you are trying to import is date make sure that is formatted in format Y-m-d (2018-06-06).', 'Si la columna que está intentando importar es fecha, asegúrese de que esté formateada en el formato Y-m-d (2018-06-06).', 'আপনি যে কলামটি আমদানির চেষ্টা করছেন সেটি যদি তারিখ হয় তা নিশ্চিত করুন যে এটি ওয়াই-এম-ডি (2018-06-06) ফর্ম্যাটে ফর্ম্যাট হয়েছে।', 'Si la colonne que vous tentez dimporter est datée, assurez-vous quelle est formatée au format Y-m-d (2018-06-06).'],
            [20, 'point3', 'Duplicate "Roll Number" (unique in section) rows will not be imported. Roll No used or not you can get from student report page search on class & section', 'Las filas duplicadas de "Número de rollo" (único en la sección) no se importarán. Rollo No se utiliza o no se puede obtener de la página de informe del alumno en clase y sección', 'সদৃশ "রোল নম্বর" (বিভাগে অনন্য) সারিগুলি আমদানি করা হবে না। রোল না ব্যবহৃত বা না আপনি ক্লাস ও বিভাগে শিক্ষার্থীর প্রতিবেদন পৃষ্ঠা সন্ধান থেকে পেতে পারেন', 'Les lignes en double "Numéro de rouleau" (uniques dans la section) ne seront pas importées. Pas de recherche doccasion ou non, vous pouvez obtenir une recherche de page de rapport d’étudiant dans la classe et la section'],
            [20, 'point4', 'Duplicate "Guardian email & Guardian Phone" rows will not be imported. Guardian email & Guardian Phone used or not you can get from student report page search on class & section', 'No se importarán filas duplicadas de "Guardian email & Guardian Phone". El correo electrónico de Guardian & Guardian Phone utilizado o no se puede obtener de la página de informe del alumno en la clase y sección', 'সদৃশ "অভিভাবক ইমেল এবং গার্ডিয়ান ফোন" সারিগুলি আমদানি করা হবে না। অভিভাবক ইমেল এবং গার্ডিয়ান ফোন ব্যবহৃত বা না আপনি ক্লাস ও বিভাগে শিক্ষার্থীর প্রতিবেদন পৃষ্ঠা সন্ধান থেকে পেতে পারেন', 'Les lignes dupliquées "Email et téléphone Guardian" ne seront pas importées. Guardian email & Guardian Phone utilisé ou non, vous pouvez obtenir une recherche dans la page de rapport de létudiant sur la classe et la section'],
            [20, 'point5', 'For student Session use Id', 'Para el estudiante Sesión use Id', 'শিক্ষার্থীদের সেশনের জন্য আইডি ব্যবহার করুন', 'Pour les étudiants "Session", utilisez lidentifiant'],
            [20, 'point6', 'For student "Gender" use ID', 'Para el estudiante "Género" usar ID', 'শিক্ষার্থীদের জন্য "লিঙ্গ" আইডি ব্যবহার করুন', 'Pour létudiant "Sexe", utilisez lidentifiant'],
            [20, 'point7', 'For student "Blood Group" use Id', 'Para el estudiante "Grupo de sangre" use ID', 'শিক্ষার্থীদের জন্য "ব্লাড গ্রুপ" আইডি ব্যবহার করুন', 'Pour les étudiants Groupe sanguin, utilisez lId'],
            [20, 'point8', 'For student "Religion" use ID', 'Para el estudiante "Religión" usar identificación', 'শিক্ষার্থীদের জন্য "ধর্ম" আইডি ব্যবহার করুন', 'Pour les étudiants Religion, utilisez votre identifiant'],
            [20, 'point9', 'For student "Guardian Relation" use capital O for Other, F for Father M for Mother.', 'Para el estudiante "Guardian Relation" use mayúscula O para Otro, F para el Padre M para la Madre.', 'শিক্ষার্থীর জন্য "গার্ডিয়ান রিলেশন" অন্যের জন্য মূলধন ও ব্যবহার করুন, মায়ের জন্য এফ ফাদার এম।', 'Pour les étudiants "Relation Gardien", utilisez la majuscule O pour Autre, F pour Père M pour Mère.'],
            [20, 'save_bulk_students', 'save bulk students', 'guardar estudiantes a granel', 'বাল্ক ছাত্রদের সংরক্ষণ করুন', 'sauver des étudiants en vrac'],
            [20, 'bank_account_number', 'Bank Account Number', 'Número de cuenta bancaria', 'ব্যাংক একাউন্ট নম্বর', 'Numéro de compte bancaire'],
            [20, 'IFSC_Code', 'IFSC Code', 'Código IFSC', 'আইএফএসসি কোড', 'Code IFSC'],
            [20, 'payment_id', 'Payment Id', 'ID de pago', 'পেমেন্ট আইডি', 'ID de paiement'],
            [20, 'passing_marks', 'Passing Marks', 'Marcas de paso', 'পাসিং মার্কস', 'Marques de passage'],
            [20, 'website', 'Website', 'Sitio web', 'ওয়েবসাইট', 'Site Internet'],
            [20, 'you_have', 'You have', 'Tienes', 'তোমার আছে', 'Tu as'],
            [20, 'notification', 'notification', 'notificación', 'প্রজ্ঞাপন', 'notification'],
            [20, 'mark_all_as_read', 'Mark All As Read', 'Marcar todo como leido', 'সবগুলো পঠিত বলে সনাক্ত কর', 'Tout marquer comme lu'],
            [20, 'view_profile', 'view profile', 'ver perfil', 'প্রোফাইল দেখুন', 'Voir le profil'],
            [20, 'completed', 'Completed', 'Terminado', 'সম্পন্ন', 'Terminé'],
            [20, 'to_do_title', 'To Do Title', 'Para hacer titulo', 'শিরোনাম করতে', 'Titre à faire'],
            [20, 'Designation_of_Signature_person', 'Designation of Signature person', 'Designación de la persona de la firma', 'স্বাক্ষর ব্যক্তির পদবি', 'Désignation de la personne signataire'],
            [20, 'student_wise', 'Student Wise', 'Estudiante sabio', 'শিক্ষার্থী বুদ্ধিমান', 'Étudiant sage'],
            [20, 'print', 'Print', 'impresión', 'ছাপা', 'impression'],
            [20, 'discount_of', 'Discount of', 'Descuento de', 'ছাড়', 'Remise de'],
            [20, 'applied', 'Applied', 'Aplicado', 'ফলিত', 'Appliqué'],
            [20, 'fees_assign', 'Fees Assign', 'Asignar cuotas', 'ফি বরাদ্দ', 'Affectation des frais'],
            [20, 'invoice_print', 'Invoice print', 'Invoice print', 'চালান প্রিন্ট', 'Invoice print'],
            [20, 'background', 'Background', 'Background', 'পটভূমি', 'Background'],
            [20, 'style', 'Style', 'Style', 'শৈলী', 'Style'],
            [20, 'color', 'Color', 'Color', 'রঙ', 'Color'],
            
            [20, 'select_position', 'Select Position', 'Select Position', 'অবস্থান নির্বাচন করুন', 'Select Position'],
            [20, 'background_settings', 'Background Settings', 'Background Settings', 'পটভূমি সেটিংস', 'Background Settings'],
            [20, 'background_type', 'Background Type', 'Background Type', 'পটভূমি প্রকার', 'Background Type'],
            [20, 'course_list', 'Course List', 'Course List', 'কোর্স তালিকা', 'Course List'],
            [20, 'about_us', 'About Us', 'About Us', 'আমাদের সম্পর্কে', 'About Us'],
            [20, 'custom_links', 'Custom Links', 'Custom Links', 'কাস্টম লিঙ্কগুলি', 'Custom Links'],
            [20, 'operation_success_message', 'Operation Successful', 'Operation Successful', 'কাজটি সফল হইসে', 'Operation Successful'],
            [20, 'home_page', 'Home Page', 'Home Page', 'হোম পৃষ্ঠা', 'Home Page'],
            [20, 'payment_id', 'Payment ID', 'Payment ID', 'পেমেন্ট আইডি', 'Payment ID'],
            [20, 'payment_ID', 'Payment ID', 'Payment ID', 'পেমেন্ট আইডি', 'Payment ID'],
            [20, 'contact', 'Contact', 'Contact', 'যোগাযোগ', 'Contact'],
            [20, 'page', 'Page', 'Page', 'পৃষ্ঠা', 'Page'],
            [20, 'SampleDataEmpty', 'Sample Data', 'Sample Data', 'নমুনা তথ্য', 'Sample Data'],
            [20, 'authentication_key_SID', 'Authentication KEY SID', 'Authentication KEY SID', 'প্রমাণীকরণ মূল এসআইডি', 'Authentication KEY SID'],
            [20, 'validation_data', 'Data Validation', 'Data Validation', 'তথ্য বৈধতা', 'Data Validation'],
            [20, 'login_permission', 'Login Permission', 'Login Permission', 'লগইন অনুমতি', 'Login Permission'],
            [20, 'profile', 'Profile', 'Profile', 'প্রোফাইল', 'Profile'],
            [20, 'primary_color', 'Primary Color', 'Primary Color', 'মৌলিক রঙ', 'Primary Color'],
            [20, 'primary_color2', 'Primary Color 2', 'Primary Color 2', 'প্রাথমিক রঙ 2', 'Primary Color 2'],
            [20, 'primary_color3', 'Primary Color 3', 'Primary Color 3', 'প্রাথমিক রঙ 3', 'Primary Color 3'],
            [20, 'title_color', 'Title Color', 'Title Color', 'শিরোনামের রঙ', 'Title Color'],
            [20, 'text_color', 'Text Color', 'Text Color', 'লেখার রঙ', 'Text Color'],
            [20, 'sidebar_bg', 'Sidebar', 'Sidebar', 'সাইডবার', 'Sidebar'],
            [20, 'widget', 'Widget', 'Widget', 'উইজেট', 'Widget'],
            [3, 'change', 'Change', 'Change', 'পরিবর্তন', 'Change'],
            [3, 'confirm', 'Confirm', 'Confirm', 'নিশ্চিত করুন', 'Confirm'],
            [3, 'restore_message', 'All sample data will restore in your database. Your existing data will be damage, so please take backup before restore.', 'All sample data will restore in your database. Your existing data will be damage, so please take backup before restore.', 'সমস্ত নমুনা ডেটা আপনার ডাটাবেসে পুনরুদ্ধার করবে। আপনার বিদ্যমান ডেটা ক্ষতি হয়ে যাবে, তাই পুনরুদ্ধার করার আগে ব্যাকআপ নিন please', 'All sample data will restore in your database. Your existing data will be damage, so please take backup before restore.'],
            [3, 'sample', 'Sample', 'Sample', 'নমুনা', 'Sample'],
            [3, 'data', 'Data', 'Data', 'উপাত্ত', 'Data'],
            [3, 'found', 'Found', 'Found', 'পাওয়া ', 'Found'],
            [3, 'empty', 'Empty', 'Empty', 'খালি', 'Empty'],
            [3, 'database', 'Database', 'Database', 'তথ্যশালা', 'Database'],
            [3, 'table', 'Table', 'Table', 'টেবিল', 'Table'],
            [3, 'key', 'KEY', 'KEY', 'মূল', 'KEY'],
            [3, 'msg91', 'MSG91', 'MSG91', 'এমএসজি 91', 'MSG91'],
            [3, 'system', 'System', 'System', 'পদ্ধতি', 'System'],
            [3, 'home', 'Home', 'Home', 'বাড়ি', 'Home'],
            [3, 'front', 'Front', 'Front', 'সদর', 'Front'],
            [3, 'heading', 'Heading', 'Heading', 'শিরোনাম', 'Heading'],
            [3, 'short', 'Short', 'Short', 'সংক্ষিপ্ত', 'Short'],
            [3, 'set_permission_in', 'Set permission in', 'Set permission in', 'মধ্যে অনুমতি সেট করুন', 'Set permission in'],
            [3, 'custom', 'Custom', 'Custom', 'প্রথা', 'Custom'],
            [3, 'field', 'Field', 'Field', 'ক্ষেত্র', 'Field'],
            [3, 'numeric', 'Numeric', 'Numeric', 'সংখ্যার', 'Numeric'],
            [3, 'multiline', 'Multiline', 'Multiline', 'বহুরেখা', 'Multiline'],
            [3, 'datepicker', 'Datepicker', 'Datepicker', 'তারিখ সংগ্রাহক', 'Datepicker'],
            [3, 'checkbox', 'Checkbox', 'Checkbox', 'চেকবক্স', 'Checkbox'],
            [3, 'radio', 'Radio', 'Radio', 'রেডিও', 'Radio'],
            [3, 'dropdown', 'Dropdown', 'Dropdown', 'ড্রপডাউন', 'Dropdown'],
            [3, 'length', 'Length', 'Length', 'দৈর্ঘ্য', 'Length'],
            [3, 'input', 'Input', 'Input', 'ইনপুট', 'Input'],
            [3, 'links', 'Links', 'Links', 'লিংক', 'Links'],
            [3, 'link', 'Link', 'Link', 'লিংক', 'Link'],
            [3, 'url', 'URL', 'URL', 'ইউআরএল', 'URL'],
            [3, 'facebook', 'Facebook', 'Facebook', 'ফেসবুক', 'Facebook'],
            [3, 'behance', 'Behance', 'Behance', 'পেশাগতভাবে', 'Behance'],
            [3, 'dribbble', 'Dribbble', 'Dribbble', 'ড্রিবল', 'Dribbble'],
            [3, 'twitter', 'Twitter', 'Twitter', 'টুইটার', 'Twitter'],
            [3, 'activated', 'Activated', 'Activated', 'সক্রিয়', 'Activated'],
            [3, 'make', 'Make', 'Make', 'মেক', 'Make'],
            [3, 'disable', 'Disable', 'Disable', 'অক্ষম', 'Disable'],
            [3, 'admin_staff', 'Admin/Staff', 'Admin/Staff', 'প্রশাসন কর্মচারীবৃন্দ', 'Admin/Staff'],
            [3, 'access', 'Access', 'Access', 'প্রবেশ', 'Access'],
            [3, 'enable', 'Enable', 'Enable', 'সক্ষম করা', 'Enable'],
            [3, 'criteria', 'Criteria', 'Criteria', 'নির্ণায়ক', 'Criteria'],
            [3, 'office', 'Office', 'Office', 'দপ্তর', 'Office'],
            [3, 'site', 'Site', 'Site', 'সাইট', 'Site'],
            [3, 'google', 'Google', 'Google', 'গুগল', 'Google'],
            [3, 'ads', 'Ads', 'Ads', 'বিজ্ঞাপন', 'Ads'],
            [3, 'campaign', 'Campaign', 'Campaign', 'ক্যাম্পেইন', 'Campaign'],
            [3, 'advertisement', 'Advertisement', 'Advertisement', 'বিজ্ঞাপন', 'Advertisement'],
            [3, 'passive', 'Passive', 'Passive', 'নিষ্ক্রিয়', 'Passive'],
            [3, 'dead', 'Dead', 'Dead', 'মৃত', 'Dead'],
            [3, 'won', 'Won', 'Won', 'ওঁন', 'Won'],
            [3, 'lost', 'Lost', 'Lost', 'নিখোঁজ', 'Lost'],
            [3, 'name', 'Name', 'Name', 'নাম', 'Name'],
            [3, 'salmon', 'Salmon', 'Salmon', 'স্যালমন মাছ', 'Salmon'],
            [3, 'shashimi', 'Shashimi', 'Shashimi', 'সশিমি', 'Shashimi'],
            [3, 'male', 'Male', 'Male', 'পুরুষ', 'Male'],
            [3, 'female', 'female', 'female', 'মহিলা', 'female'],
            [3, 'add_fees', 'Add Fees', 'Add Fees', 'ফি যোগ করুন', 'Add Fees'],
            [3, 'pay_via_paystack', 'Pay via Paystack', 'Pay via Paystack', 'পেস্ট্যাকের মাধ্যমে পরিশোধ করুন', 'Pay via Paystack'],
            [3, 'grand', 'Grand', 'Grand', 'মহান', 'Grand'],
            [3, 'are_you_sure_to_detete_this_item', 'Are you sure to detete this item', 'Are you sure to detete this item', 'আপনি কি এই আইটেমটি সনাক্ত করার বিষয়ে নিশ্চিত?', 'Are you sure to detete this item'],
            [3, 'are_you_sure_to_reject', 'Are you sure to reject', 'Are you sure to reject', 'আপনি কি প্রত্যাখ্যান নিশ্চিত??', 'Are you sure to reject'],
            [3, 'student_profile', 'Student Profile', 'Student Profile', 'ছাত্র প্রোফাইল', 'Student Profile'],
            [3, 'admission_number', 'Admission Nnumber', 'Admission Nnumber', 'ভর্তি নম্বর', 'Admission Nnumber'],
            [3, 'sibling_snformation', 'Sibling Information', 'Sibling Information', 'ভাইবোন তথ্য', 'Sibling Information'],
            [3, 'sibling_name', 'Sibling Name', 'Sibling Name', 'সহোদর নাম', 'Sibling Name'],
            [3, 'father_name', 'Father’s Name', 'Father’s Name', 'বাবার নাম', 'Father’s Name'],
            [3, 'mother_name', 'Mother’s Name', 'Mother’s Name', 'মায়ের নাম', 'Mother’s Name'],
            [3, 'guardian_name', 'Guardian’s Name', 'Guardian’s Name', 'অভিভাবকের নাম', 'Guardian’s Name'],
            [3, 'transport_and_dormitory_details', 'Transport and Dormitory Details', 'Transport and Dormitory Details', 'পরিবহন এবং ছাত্রাবাসের বিশদ', 'Transport and Dormitory Details'],
            [3, 'dormitory_name', 'Dormitory Name', 'Dormitory Name', 'আস্তানা নাম', 'Dormitory Name'],
            [3, 'other', 'Other', 'Other', 'অন্যান্য', 'Other'],
            [3, 'upload_document', 'Upload Document', 'Upload Document', 'দস্তাবেজ আপলোড করুন', 'Upload Document'],
            [3, 'document_title', 'Document Title', 'Document Title', 'নথির শিরোনাম', 'Document Title'],
            [3, 'new_document', 'New Document', 'New Document', 'নতুন দলিল', 'New Document'],
            [3, 'others_download', 'Others Download', 'Others Download', 'অন্যদের ডাউনলোড', 'Others Download'],
            [3, 'attendance_result', 'Attendance result', 'Attendance result', 'উপস্থিতি ফলাফল', 'Attendance result'],
            [3, 'dormitory_room_list', 'Dormitory Room List', 'Dormitory Room List', 'ডরমেটরি রুম তালিকা', 'Dormitory Room List'],
            [3, 'evaluation_date', 'Evaluation Date', 'Evaluation Date', 'মূল্যায়ন তারিখ', 'Evaluation Date'],
            [3, 'submission_date', 'Submission Date', 'Submission Date', 'জমাদানের তারিখ', 'Submission Date'],
            [3, 'homework_date', 'Homework date', 'Homework date', 'হোম ওয়ার্কের তারিখ', 'Homework date'],
            [3, 'subject_list', 'Subject List', 'Subject List', 'বিষয় তালিকা', 'Subject List'],
            [3, 'made', 'Made', 'Made', 'প্রণীত', 'Made'],
            [3, 'answer_script', 'Answer Script', 'Answer Script', 'উত্তর স্ক্রিপ্ট', 'Answer Script'],
            [3, 'student_book_issue', 'Student Book Issue', 'Student Book Issue', 'ছাত্র বই ইস্যু', 'Student Book Issue'],
            [3, 'all_issued_book_list', 'All Issued Book List', 'All Issued Book List', 'সমস্ত জারি বইয়ের তালিকা', 'All Issued Book List'],
            [3, 'sorry', 'Sorry', 'Sorry', 'দুঃখিত', 'Sorry'],
            [3, 'there_is_no_notice_for_you', 'There is no notice for you', 'There is no notice for you', 'আপনার জন্য কোনও নোটিশ নেই', 'There is no notice for you'],
            [3, 'available_for', 'Available For', 'Disponible para', 'সহজলভ্যের জন্যে', 'Disponible pour'],
            [3, 'take_online_exam', 'Take Online Exam', 'Take Online Exam', 'অনলাইন পরীক্ষা দিন', 'Take Online Exam'],
            [3, 'select_subject', 'Select subject', 'Select subject', 'বিষয় নির্বাচন করুন', 'Select subject'],
            [3, 'mark_as_holiday', 'Mark as Holiday', 'Mark as Holiday', 'ছুটির দিন হিসাবে চিহ্নিত করুন', 'Mark as Holiday'],
            [3, 'teacher', 'Teacher', 'Profesor', 'শিক্ষক', 'Prof'],
            [3, 'upload_content', 'Upload Content', 'Subir contenido', 'সামগ্রী আপলোড করুন', 'Télécharger du contenu'],
            [3, 'assignment', 'Assignment', 'Asignación', 'নিয়োগ', 'Affectation'],
            [3, 'content_title', 'Content Title', 'Título del contenido', 'সামগ্রীর শিরোনাম', 'Titre du contenu'],
            [3, 'study_material', 'Study Material', 'Material de estudio', 'শিক্ষাসামগ্রী', 'Matériel détude'],
            [3, 'syllabus', 'Syllabus', 'Silaba', 'পাঠ্যসূচি', 'Programme'],
            [3, 'other_download', 'Other Downloads', 'Otras descargas', 'অন্যান্য ডাউনলোড', 'Autres téléchargements'],
            [3, 'available_for', 'Available for', 'Disponible para', 'সহজলভ্যের জন্যে', 'Disponible pour'],
            [3, 'admin', 'Admin', 'Administración', 'অ্যাডমিন', 'Admin'],
            [3, 'min', 'Min', 'Min', 'নূন্যতম', 'Min'],
            [3, 'max', 'Max', 'Max', 'সর্বোচ্চ', 'Max'],
            [3, 'available_for_all_classes', 'Available for all classes', 'Disponible para todas las clases.', 'সমস্ত শ্রেণীর জন্য উপলব্ধ', 'Disponible pour toutes les classes'],
            [3, 'action', 'Action', 'Acción', 'কর্ম', 'action'],
            [3, 'source_url', 'Source URL', 'Source URL', 'উৎস', 'Source URL'],
            [3, 'content_type', 'Content Type', 'Content Type', 'বিষয়বস্তুর প্রকার', 'Content Type'],
            [3, 'all_admins', 'All Admins', 'All Admins', 'সমস্ত প্রশাসক', 'All Admins'],
            [3, 'all_students_of', 'All Students Of', 'All Students Of', 'সমস্ত ছাত্র', 'All Students Of'],
            [3, 'all_classes_student', 'All classes student', 'All classes student', 'সকল শ্রেণির শিক্ষার্থী', 'All classes student'],
            [3, 'all_classes', 'All Classes', 'All Classes', 'সকল ক্লাস', 'All Classes'],
            [3, 'click_here', 'Click Here', 'Click Here', 'এখানে ক্লিক করুন', 'Click Here'],
            [3, 'other_downloads', 'Other Downloads', 'Other Downloads', 'অন্যান্য ডাউনলোড', 'Other Downloads'],
            [3, 'other_downloads_list', 'Other Downloads List', 'Lista de otras descargas', 'অন্যান্য ডাউনলোডের তালিকা', 'Autres téléchargements'],
            [4, 'payment', 'Payment', 'Pago', 'পারিশ্রমিক', 'Paiement'],
            [4, 'reject', 'Reject', 'Reject', 'প্রত্যাখ্যান', 'Reject'],
            [4, 'payment_ID_Details', 'Payment ID Details', 'Detalles de ID de pago', 'পেমেন্ট আইডি বিশদ', 'ID de paiement'],
            [4, 'mode', 'Mode', 'Modo', 'মোড', 'Mode'],
            [4, 'amount', 'Amount', 'Cantidad', 'পরিমাণ', 'Montant'],
            [4, 'transfer', 'Transfer', 'Transfer', 'স্থানান্তর', 'Transfer'],
            [4, 'fund', 'Fund', 'Fund', 'তহবিল', 'Fund'],
            [4, 'fund_transfer', 'Fund Transfer', 'Fund Transfer', ' তহবিল স্থানান্তর', 'Fund Transfer'],
            [4, 'fine_report', 'Fine Report', 'Multa Report', 'জরিমানা রিপোর্ট', 'Bien Report'],
            [4, 'discount', 'Discount', 'Descuento', 'ডিসকাউন্ট', 'Remise'],
            [4, 'fine', 'Fine', 'Multa', 'জরিমানা', 'Bien'],
            [4, 'fees_due_list', 'Fees Due List', 'Lista de cuotas', 'ফি বকেয়া তালিকা', 'Frais à payer'],
            [4, 'due_birth', 'Due Birth', 'Nacimiento debido', 'জন্মের কারণে', 'Naissance due'],
            [4, 'deposit', 'Deposit', 'Depositar', 'আমানত', 'Dépôt'],
            [4, 'balance', 'Balance', 'Equilibrar', 'ভারসাম্য', 'Équilibre'],
            [4, 'master', 'Master', 'Dominar', 'মনিব', 'Maîtriser'],
            [4, 'assign', 'Assign', 'Asignar', 'বরাদ্দ', 'Attribuer'],
            [4, 'item', 'Item', 'ít', 'পদ', 'Article'],
            [4, 'content', 'content', 'contenido', 'সন্তুষ্ট', 'contenu'],
            [4, 'fees_code', 'Fees Code', 'Código de Cuotas', 'ফি কোড', 'Code des frais'],
            [4, 'code', 'Code', 'Código', 'কোড', 'Code'],
            [4, 'once', 'Once', 'Una vez', 'একদা', 'Une fois que'],
            [4, 'year', 'Year', 'Año', 'বছর', 'Année'],
            [4, 'previous_Session_Balance_Fees', 'Previous Session Balance Fees', 'Cuotas de balance de la sesión anterior', 'পূর্ববর্তী সেশন ব্যালেন্স ফি', 'Frais de solde de la session précédente'],
            [4, 'previous_balance_can_only_update_now.', 'Previous balance already forwarded, you can only update now.', 'El saldo anterior ya reenviado, solo se puede actualizar ahora.', 'পূর্ববর্তী ব্যালেন্স ইতিমধ্যে ফরওয়ার্ড করা হয়েছে, আপনি কেবলমাত্র এখনই আপডেট করতে পারবেন।', 'Le solde précédent ayant déjà été transféré, vous ne pouvez mettre à jour que maintenant.'],
            [4, 'fees_collection', 'Fees Collection', 'Colección de tarifas', 'ফি সংগ্রহ', 'Collection de frais'],
            [4, 'collect_fees', 'Collect Fees', 'Cobrar honorarios', 'ফি সংগ্রহ করুন', 'Recueillir les frais'],
            [4, 'search_fees_payment', 'Search Fees Payment', 'Pago de tarifas de búsqueda', 'অনুসন্ধানের পেমেন্ট', 'Recherche des frais de paiement'],
            [4, 'search_fees_due', 'Search Fees Due', 'Tarifas de búsqueda vencidas', 'পারিশ্রমিক ফি', 'Frais de recherche dus'],
            [4, 'fees_master', 'Fees Master', 'Honorarios maestro', 'ফি মাস্টার', 'Frais Maître'],
            [4, 'fees_group', 'Fees Group', 'Grupo de tarifas', 'ফি গ্রুপ', 'Groupe de frais'],
            [4, 'fees_type', 'Fees Type', 'Tipo de Cuotas', 'ফি প্রকার', 'Type de frais'],
            [4, 'fees_discount', 'Fees Discount', 'Tarifas de descuento', 'ফি ছাড়', 'Remise des frais'],
            [4, 'fees_forward', 'Fees Carry Forward', 'Cuotas de llevar adelante', 'ফি ফরওয়ার্ড বহন', 'Frais reportés'],
            [5, 'accounts', 'Accounts', 'Cuentas', 'অ্যাকাউন্টস', 'Comptes'],
            [5, 'profit', 'Profit', 'Lucro', 'মুনাফা', 'Profit'],
            [5, 'income', 'Income', 'Ingresos', 'আয়', 'le revenu'],
            [5, 'expense', 'Expense', 'Gastos', 'ব্যয়', 'Frais'],
            [5, 'chart_of_account', 'Chart Of Account', 'Plan de cuentas', 'অ্যাকাউন্ট চার্ট', 'Charte dutilisation'],
            [5, 'payment_method', 'Payment Method', 'Método de pago', 'মূল্যপরিশোধ পদ্ধতি', 'Mode de paiement'],
            [5, 'bank_account', 'Bank Account', 'Cuenta bancaria', 'ব্যাংক হিসাব', 'Compte bancaire'],
            [5, 'a_c_Head', 'A/C Head', 'A / C Head', 'এ / সি হেড', 'Tête A / C'],
            [5, 'add_expense', 'Add Expense', 'Añadir gastos', 'ব্যয় যুক্ত করুন', 'Ajouter une dépense'],
            [5, 'search_income_expense', 'Search Income/Expense', 'Buscar ingresos / gastos', 'ইনকাম / ব্যয় অনুসন্ধান করুন', 'Recherche revenu / dépense'],
            [5, 'item_Receive', 'Item Receive', 'El artículo recibe', 'আইটেম রিসিভ', 'Point recevoir'],
            [5, 'income_head', 'Income Head', 'Jefe de ingresos', 'ইনকাম হেড', 'Chef de revenu'],
            [5, 'sells', 'Sells', 'Vende', 'বিক্রি', 'Vend'],
            [5, 'grand_total', 'Grand Total', 'Gran total', 'সর্বমোট', 'somme finale'],
            [5, 'and', 'And', 'And', 'এবং', 'And'],
            [5, 'for', 'For', 'For', 'জন্য', 'For'],
            [5, 'expense_head', 'Expense Head', 'Cabeza de gastos', 'ব্যয় প্রধান', 'Chef de dépenses'],
            [5, 'purchase', 'Purchase', 'Compra', 'ক্রয়', 'achat'],
            [5, 'from', 'From', 'Desde', 'থেকে', 'De'],
            [5, 'upto', 'Upto', 'Upto', 'পর্যন্ত', 'Upto'],
            [5, 'head', 'Head', 'Cabeza', 'মাথা', 'Tête'],
            [5, 'method', 'Method', 'Método', 'পদ্ধতি', 'Méthode'],
            [5, 'account_name', 'Account Name', 'Nombre de la cuenta', 'হিসাবের নাম', 'Nom du compte'],
            [5, 'opening_balance', 'Opening Balance', 'Saldo de apertura', 'খোলার ভারসাম্য', 'Solde douverture'],
            [5, 'account', 'Account', 'Cuenta', 'হিসাব', 'Compte'],
            [6, 'human_resource', 'Human Resource', 'Recursos humanos', 'মানব সম্পদ', 'Ressource humaine'],
            [6, 'staff_directory', 'Staff Directory', 'Directorio de Personal', 'স্টাফ ডিরেক্টরি', 'Répertoire personnel'],
            [6, 'staff_attendance', 'Staff Attendance', 'Asistencia del personal', 'কর্মীদের উপস্থিতি', 'Présence du personnel'],
            [6, 'staff_attendance_report', 'Staff Attendance Report', 'Informe de asistencia del personal', 'কর্মীদের উপস্থিতি রিপোর্ট', 'Rapport de présence du personnel'],
            [6, 'payroll', 'Payroll', 'Nómina de sueldos', 'বেতনের', 'Paie'],
            [6, 'payroll_report', 'Payroll Report', 'Informe de nómina', 'বেতন তালিকা', 'Rapport de paie'],
            [6, 'approve_leave_request', 'Approve Leave Request', 'Aprobar Solicitud de Licencia', 'ছুটির অনুরোধ অনুমোদন করুন', 'Approuver la demande de congé'],
            [6, 'apply_leave', 'Apply Leave', 'Aplicar licencia', 'ছুটি প্রয়োগ করুন', 'Appliquer congé'],
            [6, 'leave_type', 'Leave Type', 'Dejar Tipo', 'প্রস্থান প্রকার', 'Laisser Type'],
            [6, 'department', 'Department', 'Departamento', 'বিভাগ', 'département'],
            [6, 'designation', 'Designation', 'Designacion', 'উপাধি', 'La désignation'],
            [6, 'staff_list', 'Staff List', 'Lista de personal', 'স্টাফ তালিকা', 'Liste du personnel'],
            [6, 'add_staff', 'Add Staff', 'Añadir personal', 'স্টাফ যোগ করুন', 'Ajouter du personnel'],
            [6, 'search_by_staff_id', 'Search By Staff Id', 'Búsqueda por identificación del personal', 'স্টাফ আইডি দ্বারা অনুসন্ধান করুন', 'Rechercher par ID de personnel'],
            [6, 'staff', 'Staff', 'Personal', 'কর্মী', 'Personnel'],
            [6, 'select_role', 'Select Role', 'Seleccionar rol', 'ভূমিকা নির্বাচন করুন', 'Sélectionnez un rôle'],
            [6, 'generate_payroll', 'Generate Payroll', 'Generar Nómina', 'পে-রোল উত্পন্ন করুন', 'Générer la paie'],
            [6, 'generated', 'Generate', 'Generar', 'জেনারেট করুন', 'produire'],
            [6, 'paid', 'Paid', 'Pagado', 'পেইড', 'Payé'],
            [6, 'not', 'Not', 'No', 'না', 'ne pas'],
            [6, 'proceed_to_pay', 'Proceed to Pay', 'Proceda a pagar', 'প্রদান করতে এগিয়ে যান', 'Procéder au paiement'],
            [6, 'view_payslip', 'View Payslip', 'Ver recibo de sueldo', 'পেইস্লিপ দেখুন', 'Voir fiche de paie'],
            [6, 'month', 'Month', 'Mes', 'মাস', 'Mois'],
            [6, 'payslip', 'Payslip', 'Boleta de pago', 'স্লিপে', 'Fiche de paie'],
            [6, 'basic_salary', 'Basic Salary', 'Salario base', 'মূল বেতন', 'Salaire de base'],
            [6, 'earnings', 'Earnings', 'Ganancias', 'উপার্জন', 'Gains'],
            [6, 'deductions', 'Deductions', 'Deducciones', 'কর্তন', 'Déductions'],
            [6, 'gross_salary', 'Gross Salary', 'Salario bruto', 'মোট বেতন', 'Salaire brut'],
            [6, 'tax', 'Tax', 'Impuesto', 'কর', 'Impôt'],
            [6, 'net_salary', 'Net Salary', 'Sueldo neto', 'মোট বেতন', 'Salaire net'],
            [6, 'to', 'To', 'A', 'প্রতি', 'À'],
            [6, 'apply_date', 'Apply Date', 'Fecha de aplicación', 'আবেদনের তারিখ', 'Date dapplication'],
            [6, 'pending', 'Pending', 'Pendiente', 'বিচারাধীন', 'en attendant'],
            [6, 'static', 'Static', 'Static', 'স্থির', 'Static'],
            [6, 'ongoing', 'Ongoing', 'Ongoing', 'চলমান', 'Ongoing'],
            [6, 'close', 'Close', 'Close', 'বন্ধ', 'Close'],
            [6, 'approved', 'Approved', 'Aprobado', 'অনুমোদিত', 'Approuvé'],
            [6, 'cancelled', 'Cancelled', 'Cancelado', 'বাতিল করা হয়েছে', 'Annulé'],
            [6, 'leave_from', 'Leave From', 'Dejar de', 'থেকে ত্যাগ', 'Partir de'],
            [6, 'leave_to', 'Leave To', 'Dejar', 'ছেড়ে', 'Laisser à'],
            [6, 'reason', 'Reason', 'Razón', 'কারণ', 'Raison'],
            [6, 'type_name', 'Type Name', 'Escribe un nombre', 'নাম টাইপ করুন', 'Nom du type'],
            [6, 'total_days', 'Total Days', 'Días totales', 'মোট দিন', 'Nombre total de jours'],
            [6, 'leave_type_list', 'Leave Type List', 'Deja la lista de tipos', 'প্রকারের তালিকা ছেড়ে দিন', 'Quitter la liste des types'],
            [6, 'departments', 'Departments', 'Departamentos', 'বিভাগ', 'Départements'],
            [6, 'department_name', 'Department Name', 'Nombre de Departamento', 'বিভাগ নাম', 'Nom du département'],
            [6, 'designations', 'Designations', 'Designaciones', 'প্রশিক্ষণে', 'Désignations'],
            [6, 'staffs_payroll', 'Staffs Payroll', 'Nómina de personal', 'স্টাফদের বেতন', 'Personnel'],
            [6, 'staff_no', 'Staff No', 'Personal No', 'স্টাফ নং', 'Numéro du personnel'],
            [6, 'date_of_joining', 'Date of Joining', 'Fecha de inscripción', 'যোগদানের তারিখ', 'Date dadhésion'],
            [6, 'value', 'Value', 'Valor', 'মান', 'Valeur'],
            [6, 'payroll_summary', 'Payroll Summary', 'Resumen de nómina', 'পে-রোল সংক্ষিপ্তসার', 'Résumé de la paie'],
            [6, 'calculate', 'Calculate', 'Calcular', 'ক্যালকুলেট', 'Calculer'],
            [6, 'earning', 'Earning', 'Ganador', 'রোজগার', 'Revenus'],
            [6, 'deduction', 'Deduction', 'Deducción', 'ছাড়', 'Déduction'],
            [6, 'submit', 'Submit', 'Enviar', 'জমা দিন', 'Soumettre'],
            [6, 'edit_staff', 'Edit Staff', 'Editar Personal', 'কর্মীদের সম্পাদনা করুন', 'Modifier le personnel'],
            [6, 'basic_info', 'Basic Info', 'Información básica', 'মৌলিক তথ্য', 'Informations de base'],
            [6, 'staff_number', 'Staff Number', 'Numero de personal', 'স্টাফ নম্বর', 'Numéro du personnel'],
            [6, 'emergency_mobile', 'Emergency Mobile', 'Móvil de emergencia', 'জরুরী মোবাইল', 'Mobile durgence'],
            [6, 'current_address', 'Current Address', 'Direccion actual', 'বর্তমান ঠিকানা', 'Adresse actuelle'],
            [6, 'permanent_address', 'Permanent Address', 'dirección permanente', 'স্থায়ী ঠিকানা', 'Adresse permanente'],
            [6, 'qualifications', 'Qualifications', 'Calificaciones', 'যোগ্যতা', 'Qualifications'],
            [6, 'experience', 'Experience', 'Experiencia', 'অভিজ্ঞতা', 'Expérience'],
            [6, 'payroll_details', 'Payroll Details', 'Detalles de la nómina', 'বেতনের বিশদ', 'Détails de la paie'],
            [6, 'epf_no', 'EPF NO', 'EPF NO', 'ইপিএফ নং', 'EPF NO'],
            [6, 'bank_info_details', 'Bank Info Details', 'Detalles de la información del banco', 'ব্যাংক তথ্য বিশদ', 'Informations bancaires'],
            [6, 'bank_account_name', 'Bank Account Name', 'Nombre de la cuenta bancaria', 'ব্যাংক হিসাব নাম', 'Nom du compte bancaire'],
            [6, 'branch_name', 'Branch Name', 'Nombre de la rama', 'শাখার নাম', 'Nom de la filiale'],
            [6, 'social_links_details', 'Social Links Details', 'Detalles de enlaces sociales', 'সামাজিক লিঙ্কের বিশদ', 'Liens sociaux Détails'],
            [6, 'facebook_url', 'Facebook Url', 'Facebook URL', 'ফেসবুক ইউআর', 'Ladresse URL de Facebook'],
            [6, 'twitter_url', 'Twitter Url', 'URL de Twitter', 'টুইটার ইউআরএল', 'URL de Twitter'],
            [6, 'linkedin_url', 'Linkedin Url', 'Linkedin url', 'লিঙ্কডিন উরল', 'URL de Linkedin'],
            [6, 'instragram_url', 'Instragram Url', 'Url de instagram', 'ইনস্ট্রগ্রাম ইউরাল', 'URL Instragram'],
            [6, 'update_staff', 'Update Staff', 'Personal de actualización', 'হালনাগাদ স্টাফ', 'Mettre à jour le personnel'],
            [6, 'pending_leave_request', 'Pending Leave', 'Pending Leave', 'মুলতুবি ছুটি', 'Pending Leave'],
            [7, 'leave', 'Leave', 'Salir', 'ছুটি', 'Laisser'],
            [7, 'leave_define', 'Leave Define', 'Dejar definir', 'ছেড়ে দিন', 'Quitter Définir'],
            [7, 'add_days', 'Add Days', 'Add Days', 'দিন যোগ করুন', 'Add Days'],
            [7, 'my_remaining_leaves', 'My Remaining Leaves', 'Mis hojas restantes', 'আমার বাকী পাতা', 'Mes feuilles restantes'],
            [7, 'remaining_days', 'Remaining Days', 'Días restantes', 'বাকি দিনগুলো', 'Jours restants'],
            [7, 'extra_taken', 'Extra Taken', 'Extra Taken', 'অতিরিক্ত নেওয়া', 'Extra pris'],
            [7, 'leave_taken', 'Leave Taken', 'Leave Taken', 'ছুটি নেওয়া', 'Leave pris'],
            [7, 'leave_days', 'Leave Days', 'Leave Days', 'ছুটির দিন', 'Leave Days'],
            [7, 'total_days', 'Total Days', 'Días totales', 'মোট দিন', 'Nombre total de jours'],
            [7, 'days', 'Days', 'Dias', 'দিন', 'Journées'],
            [7, 'day', 'Day', 'Dia', 'দিন', 'Journée'],
            [8, 'examination', 'Examination', 'Examen', 'পরীক্ষা', 'Examen'],
            [8, 'exam_time_setup', 'Add Exam Setup', 'Add Exam Setup', 'পরীক্ষার সেটআপ যুক্ত করুন', 'Add Exam Setup'],
            [8, 'exam', 'Exam', 'Examen', 'পরীক্ষা', 'Examen'],
            [8, 'add_exam_type', 'Add Exam Type', 'Añadir tipo de examen', 'পরীক্ষার ধরণ যুক্ত করুন', 'Ajouter un type dexamen'],
            [8, 'exam_schedule', 'Exam Schedule', 'Horario del examen', 'পরীক্ষার সময়সূচী', 'Calendrier des examens'],
            [8, 'marks_register', 'Marks Register', 'Registro de marcas', 'চিহ্ন নিবন্ধ', 'Registre des marques'],
            [8, 'final_result', 'Final Result', 'Final Result', 'সর্বশেষ ফলাফল', 'Final Result'],
            [8, 'seat_plan', 'Seat Plan', 'Plan de asiento', 'আসন পরিকল্পনা', 'Plan de siège'],
            [8, 'exam_attendance', 'Exam Attendance', 'Examen de asistencia', 'পরীক্ষার উপস্থিতি', 'Présence à lexamen'],
            [8, 'with', 'With', 'With', 'সঙ্গে', 'With'],
            [8, 'marks_grade', 'Marks Grade', 'Nota de calificaciones', 'গ্রেড চিহ্নিত', 'Note de marques'],
            [8, 'custom_result_setting', 'Custom Result Setting', 'Custom Result Setting', 'কাস্টম ফলাফল সেট', 'Custom Result Setting'],
            [8, 'send_marks_by_sms', 'Send Marks By Sms', 'Enviar marcas por sms', 'এসএমএস দ্বারা চিহ্ন প্রেরণ করুন', 'Envoyer des marques par sms'],
            [8, 'percentage', 'Percentage', 'Percentage', 'শতকরা হার', 'Percentage'],
            [8, 'fcm_key', 'FCM KEY', 'FCM KEY', 'FCM KEY', 'FCM KEY'],
            [8, 'random_question', 'Random Question', 'Random Question', 'Random Question', 'Random Question'],
            [8, 'question_group', 'Question Group', 'Grupo de preguntas', 'প্রশ্ন গ্রুপ', 'Groupe de questions'],
            [8, 'with_out', 'With out', 'With out', 'বিনা', 'With out'],
            [8, 'question_bank', 'Question Bank', 'Banco de preguntas', 'প্রশ্ন ব্যাংক', 'Banque de questions'],
            [8, 'online_exam', 'Online Exam', 'Examen en linea', 'অনলাইন পরীক্ষা', 'Examen en ligne'],
            [8, 'exam_type', 'Exam Type', 'Tipo de examen', 'পরীক্ষার ধরণ', 'Type dexamen'],
            [8, 'exam_setup', 'Exam Setup', 'Configuración del examen', 'পরীক্ষা সেটআপ', 'Configuration de lexamen'],
            [8, 'exam_setup_role', 'Exam Setup ROle', 'Configuración del examen role', 'পরীক্ষা সেটআপ ভূমিকা', 'Configuration de lexamen role'],
            [8, 'setup_exam_role', 'Setup Exam ROle', 'Configuración del examen role', 'পরীক্ষা সেটআপ ভূমিকা', 'Configuration de lexamen role'],

            [8, 'exam_name', 'Exam Name', 'Nombre del examen', 'পরীক্ষার নাম', 'Nom de lexamen'],
            [8, 'sl', 'Sl', 'Sl', 'ক্রমিক', 'Sl'],
            [8, 'select_subjects', 'Select Subjects', 'Temas seleccionados', 'বিষয় নির্বাচন করুন', 'Sélectionner des sujets'],
            [8, 'exam_mark', 'Exam Mark', 'Marca de examen', 'পরীক্ষার চিহ্ন', 'Marque dexamen'],
            [8, 'add_mark_distributions', 'Add Mark Distributions', 'Añadir Distribuciones de Marca', 'চিহ্ন বিতরণ যুক্ত করুন', 'Ajouter des distributions de marques'],
            [8, 'exam_title', 'Exam Title', 'Título del examen', 'পরীক্ষার শিরোনাম', 'Titre de lexamen'],
            [8, 'ct_AT_Exam', 'Name', 'Nombre', 'নাম', 'prénom'],
            [8, 'mark_distribution', 'Mark Distribution', 'Distribución de marcas', 'চিহ্ন বিতরণ', 'Distribution des marques'],
            [8, 'subject', 'Subject', 'Tema', 'বিষয়', 'Assujettir'],
            [8, 'total_mark', 'Total Mark', 'Marca total', 'মোট চিহ্ন', 'Total Mark'],
            [8, 'view_status', 'View Status', 'Ver el estado de', 'স্থিতি দেখুন', 'Voir le statut'],
            [8, 'copy', 'Copy', 'Dupdo', 'অনুলিপি', 'Copie'],
            [8, 'add_exam_schedule', 'Add Exam Schedule', 'añadir horario de exámenes', 'পরীক্ষার সময়সূচী যুক্ত করুন', 'ajouter un calendrier dexamen'],
            [8, 'FALSE', 'FALSE', 'FALSE', 'মিথ্যা', 'FALSE'],
            [8, 'exam_list', 'Exam List', 'Lista de exámenes', 'পরীক্ষার তালিকা', 'Liste dexamen'],
            [8, 'archive', 'Archive', 'Archive', 'সংরক্ষাণাগার', 'Archive'],
            [8, 'marks', 'Marks', 'Marcas', 'চিহ্ন', 'Des notes'],
            [8, 'waiting_for', 'Waiting For', 'Waiting For', 'অপেক্ষা করা', 'Waiting For'],
            [8, 'official', 'Official', 'Official', 'দাপ্তরিক', 'Official'],
            [8, 'select_exam', 'Select Exam', 'Seleccionar examen', 'পরীক্ষা নির্বাচন করুন', 'Sélectionnez un examen'],
            [8, 'transcript', 'Transcript', 'Transcript', 'প্রতিলিপি', 'Transcript'],
            [8, 'percent', 'Percent', 'Por ciento', 'শতাংশ', 'Pour cent'],
            [8, 'previous', 'Previous', 'Previous', 'আগে', 'Previous'],
            [8, 'previous_record', 'Previous Record', 'Previous Record', 'আগে নথি', 'Previous Record'],
            [8, 'seat_plan_report', 'Seat Plan Report', 'Informe del plan de asiento', 'আসন পরিকল্পনা প্রতিবেদন', 'Rapport de plan de siège'],
            [8, 'record', 'Record', 'Record', 'নথি', 'Record'],
            [8, 'assign_students', 'Assign Students', 'Asignar estudiantes', 'ছাত্র নিয়োগ করুন', 'Attribuer des étudiants'],
            [8, 'search_by_year', 'Search by Year', 'Search by Year', 'বছর অনুসারে অনুসন্ধান করুন', 'Search by Year'],
            [8, 'start_end_time', 'start-end time', 'hora de inicio y fin', 'শুরুর সময়', 'heure de début'],
            [8, 'button', 'Button', 'Button', 'বোতাম', 'Button'],
            [8, 'total_students', 'Total Student', 'Total de estudiante', 'মোট ছাত্র', 'Total des étudiant'],
            [8, 'exam_not_found', 'Exam schedule is not available.', 'Exam schedule is not available.', 'পরীক্ষার সময়সূচী পাওয়া যায় না।', 'Exam schedule is not available.'],
            [8, 'attendance_create', 'Attendance Create', 'Asistencia Crear', 'উপস্থিতি তৈরি করুন', 'Présence Créer'],
            [8, 'biometrics', 'Biometrics', 'Biometrics', 'বায়োমেট্রিক্স', 'Biometrics'],
            [8, 'grade', 'Grade', 'Grado', 'শ্রেণী', 'Qualité'],
            [8, 'consider_start_time', 'Consider Start Time', 'Consider Start Time', 'শুরুর সময় বিবেচনা করুন', 'Consider Start Time'],
            [8, 'gpa', 'GPA', 'GPA', 'জিপিএ', 'GPA'],
            [8, 'consider_end_time', 'Consider End Time', 'Consider End Time', 'সমাপ্তির সময় বিবেচনা করুন', 'Consider End Time'],
            [8, 'percent_from', 'Percent From', 'Porcentaje de', 'শতাংশ থেকে', 'Pour cent de'],
            [8, 'percent_upto', 'Percent Upto', 'Por ciento hasta', 'শতকরা পর্যন্ত', 'Pourcentage jusquà'],
            [8, 'send_marks_via_SMS', 'Send Marks Via SMS', 'Enviar marcas a través de SMS', 'এসএমএসের মাধ্যমে চিহ্নগুলি প্রেরণ করুন', 'Envoyer des marques par SMS'],
            [8, 'seen', 'Seen', 'Seen', 'দেখা', 'Seen'],
            [8, 'unseen', 'Unseen', 'Unseen', 'অদেখা', 'Unseen'],
            [8, 'log', 'Log', 'Log', 'লগ', 'Log'],
            [8, 'question_show_in_single_page', 'Per Questions show in single page', 'Per Questions show in single page', 'Per Questions show in single page', 'Per Questions show in single page'],
            [8, 'mcq', 'MCQ', 'MCQ', 'MCQ', 'MCQ'],
            [8, 'answer_type', 'Answer Type', 'Answer Type', 'উত্তর প্রকার', 'Answer Type'],
            [8, 'answer', 'Answer', 'Answer', 'উত্তর', 'Answer'],
            [8, 'single_select', 'Single Select', 'Single Select', 'একক নির্বাচন', 'Single Select'],
            [8, 'multiple_select', 'Multiple Select', 'Multiple Select', 'একাধিক নির্বাচন', 'Multiple Select'],
            [8, 'question_image', 'Question Image', 'Question Image', 'প্রশ্ন ইমেজ', 'Question Image'],
            [8, 'time_setup', 'Time Setup', 'Time Setup', 'প্রশ্ন ইমেজ', 'Time Setup'],
            [8, 'student_absent_notification_sms ', 'Student Absent Notification', 'Student Absent Notification', 'ছাত্র অনুপস্থিতি বিজ্ঞপ্তি', 'Student Absent Notification'],
            [8, 'Ending', 'Ending', 'Ending', 'শেষ', 'Ending'],
            [8, 'select_receiver', 'Select Receiver', 'Seleccionar Receptor', 'রিসিভার নির্বাচন করুন', 'Sélectionnez le destinataire'],
            [8, 'final_result', 'Final Result', 'Final Result', 'সর্বশেষ ফলাফল', 'Final Result'],
            [8, 'students', 'Students', 'Estudiantes', 'শিক্ষার্থীরা', 'Étudiants'],
            [8, 'third_term', 'Third Term', 'Third Term', 'তৃতীয় মেয়াদ', 'Third Term'],
            [8, 'select_group', 'Select Group', 'Selecciona grupo', 'গ্রুপ নির্বাচন করুন', 'Sélectionner un groupe'],
            [8, 'second_term', 'Second Term', 'Second Term', 'দ্বিতীয় মেয়াদে', 'Second Term'],
            [8, 'question_type', 'Question Type', 'tipo de pregunta', 'প্রশ্নের ধরন', 'Type de question'],
            [8, 'first_term', 'First Term', 'First term', 'প্রথম পক্ষ', 'First term'],
            [8, 'multiple_choice', 'Multiple Choice', 'Opción multiple', 'বহু নির্বাচনী', 'Choix multiple'],
            [8, 'multiple_image', 'Multiple Image', 'Multiple Image', 'একাধিক চিত্র', 'Multiple Image'],
            [8, 'watch', 'Watch Video', 'Watch Video', 'ভিডিও দেখা', 'Watch Video'],
            [8, 'create_class_routine', 'Create Class Routine', 'Create class routine', 'শ্রেণীর রুটিন তৈরি করুন', 'Create class routine'],
            [8, 'true_false', 'True False', 'Verdadero Falso', 'সত্য মিথ্যা', 'Vrai faux'],
            [8, 'optional', 'Optional', 'Optional', 'ঐচ্ছিক', 'Optional'],
            [8, 'fill_in_the_blanks', 'Fill in the Blanks', 'Rellenar los espacios en blanco', 'শুন্যস্তান পূরণ', 'Remplir les espaces vides'],
            [8, 'question', 'Question', 'Pregunta', 'প্রশ্ন', 'Question'],
            [8, 'number_of_options', 'Number Of Options', 'Número de opciones', 'বিকল্পের সংখ্যা', 'Nombre doptions'],
            [8, 'with', 'With', 'With', 'সঙ্গে', 'With'],
            [8, 'create', 'Create', 'Crear', 'সৃষ্টি', 'Créer'],
            [8, 'with_out', 'With out', 'With out', 'বিনা', 'With out'],
            [8, 'option', 'Option', 'Opción', 'পছন্দ', 'Option'],
            [8, 'true', 'TRUE', 'CIERTO', 'সত্য', 'VRAI'],
            [8, 'setting', 'Settings', 'Settings', 'Settings', 'Settings'],
            [8, 'false', 'FALSE', 'FALSO', 'মিথ্যা', 'FAUX'],
            [8, 'suitable_words', 'Suitable Words', 'Palabras adecuadas', 'উপযুক্ত শব্দ', 'Mots convenables'],
            [8, 'start_time', 'Start Time', 'Hora de inicio', 'সময় শুরু', 'Heure de début'],
            [8, 'end_time', 'End Time', 'Hora de finalización', 'শেষ সময়', 'Heure de fin'],
            [8, 'minimum_percentage', 'Minimum Percentage', 'Porcentaje mínimo', 'সর্বনিম্ন শতাংশ', 'Pourcentage minimum'],
            [8, 'Wait_Till_Exam_Finish', 'Wait Till Exam Finish', 'Porcentaje mínimo', 'পরীক্ষা শেষ হওয়া পর্যন্ত অপেক্ষা করুন', 'Pourcentage minimum'],
            [8, 'instruction', 'Instruction', 'Instrucción', 'নির্দেশ', 'Instruction'],
            [8, 'exam_date', 'Exam Date', 'Fecha de examen', 'পরীক্ষার তারিখ', 'Date de lexamen'],
            [8, 'short_answer', 'Short Answer', 'Short Answer', 'Short Answer', 'Short Answer'],
            [8, 'image_question', 'Image Question', 'Image Question', 'Image Question', 'Image Question'],
            [8, 'pair_match', 'Pair Match', 'Pair Match', 'Pair Match', 'Pair Match'],
            [8, 'subjective', 'Subjective', 'Subjective', 'Subjective', 'Subjective'],
            [8, 'deduct_marks', 'Deduct Marks for negative questions', 'Deduct Marks for negative questions', 'Deduct Marks for negative questions', 'Deduct Marks for negative questions'],
            [8, 'exam_submittion_time', 'Exam Submittion Time', 'Exam Submittion Time', 'Exam Submittion Time', 'Exam Submittion Time'],
            [8, 'time', 'Time', 'Hora', 'সময়', 'Temps'],
            [8, 'audio', 'Audio', 'Audio', 'Audio', 'Audio'],
            [8, 'pdf_resource', 'Pdf Resource', 'Pdf Resource', 'Pdf Resource', 'Pdf Resource'],
            [8, 'external_resource', 'External Resource', 'External Resource', 'External Resource', 'External Resource'],
            [8, 'layout', 'Layout', 'Layout', 'Layout', 'Layout'],
            [8, 'any_question_access', 'Any Question Access', 'Any Question Access', 'Any Question Access', 'Any Question Access'],
            [8, 'scan_upload', 'Scan Upload', 'Scan Upload', 'Scan Upload', 'Scan Upload'],
            [8, 'pdf_exam', 'Interactive Exam', 'Interactive Exam', 'Interactive Exam', 'Interactive Exam'],
            [8, 'pdf_exam_result', 'Interactive Exam Result', 'Interactive Exam Result', 'Interactive Exam Result', 'Interactive Exam Result'],
            [8, 'scan_file', 'Scan File', 'Scan File', 'Scan File', 'Scan File'],
            [8, 'question_pdf', 'Question Pdf', 'Question Pdf', 'Question Pdf', 'Question Pdf'],
            [8, 'subject_attendance_layout', 'Subject Attendance Layout', 'Subject Attendance Layout', 'বিষয় উপস্থিতি বিন্যাস', 'Subject Attendance Layout'],
            [8, 'published', 'Published', 'Publicado', 'প্রকাশিত', 'Publié'],
            [8, 'unpublished', 'Unpublished', 'Unpublished', 'অপ্রকাশিত', 'Unpublished'],
            [8, 'manage_question', 'Manage Question', 'Gestionar pregunta', 'প্রশ্ন পরিচালনা করুন', 'Gérer la question'],
            [8, 'published_now', 'Published Now', 'Publicado ahora', 'এখন প্রকাশিত', 'Publié maintenant'],
            [8, 'view_result', 'View Result', 'Ver resultado', 'ফলাফল দেখুন', 'Voir résultat'],
            [8, 'monday', 'Monday', 'lunes', 'সোমবার', 'Lundi'],
            [8, 'tuesday', 'Tuesday', 'martes', 'মঙ্গলবার', 'Mardi'],
            [8, 'wednesday', 'Wednesday', 'miércoles', 'বুধবার', 'Mercredi'],
            [8, 'thursday', 'Thursday', 'jueves', 'বৃহস্পতিবার', 'Jeudi'],
            [8, 'friday', 'Friday', 'viernes', 'শুক্রবার', 'Vendredi'],
            [8, 'Saturday', 'Saturday', 'sábado', 'শনিবার', 'samedi'],
            [8, 'sunday', 'Sunday', 'domingo', 'রবিবার', 'dimanche'],
            [8, 'room_number', 'Room Number', 'Número de habitación', 'রুম নম্বর', 'Numéro de chambre'],
            [8, 'not_scheduled', 'Not Scheduled', 'No programada', 'নির্ধারিত না', 'Non prévu'],
            [8, 'result_view', 'Result View', 'Vista de resultados', 'ফলাফল দেখুন', 'Résultat'],
            [8, 'total_marks', 'Total Marks', 'Notas totales', 'মোট চিহ্ন', 'Total des notes'],
            [8, 'obtained_marks', 'Obtained Marks', 'Marcas obtenidas', 'প্রাপ্ত নম্বর', 'Obtenu Marques'],
            [8, 'marking', 'Marking', 'Calificación', 'অবস্থানসূচক', 'Marquage'],
            [8, 'view_answer_marking', 'View answer & marking', 'Ver respuesta y marcado', 'উত্তর ও চিহ্নিতকরণ দেখুন', 'Voir la réponse et le marquage'],
            [8, 'online_exam_question', 'Online Exam Question', 'Pregunta de examen en línea', 'অনলাইন পরীক্ষার প্রশ্ন', 'Question dexamen en ligne'],
            [8, 'question_list', 'Question List', 'Lista de preguntas', 'প্রশ্ন তালিকা', 'Liste de questions'],
            [8, 'questions', 'Questions', 'Preguntas', 'প্রশ্নাবলি', 'Des questions'],
            [8, 'previous_class_result', 'Previous Class  Result', 'Previous Class  Result', 'আগে ক্লাস ফলাফল', 'Previous Class Result'],
            [8, 'exam_details', 'Exam Details', 'Detalles del examen', 'পরীক্ষার বিবরণ', 'Détails de lexamen'],
            [8, 'passing_percentage', 'Passing Percentage', 'Pasando el porcentaje', 'পাসিং পার্সেন্টেজ', 'Passage Pourcentage'],
            [8, 'online_active_exams', 'Online Active Exams', 'Exámenes activos en línea', 'অনলাইন অ্যাক্টিভ পরীক্ষা', 'Examens actifs en ligne'],
            [8, 'take_exam', 'Take Exam', 'Tomar examen', 'পরীক্ষা দিন', 'Passer un examen'],
            [8, 'classes', 'Classes', 'Las clases', 'ক্লাস', 'Des classes'],
            [8, 'exam_terms', 'Exam Terms', 'Términos del examen', 'পরীক্ষার শর্তাদি', 'Termes de lexamen'],
            [8, 'document', 'Document', 'Document', 'দলিল', 'Document'],
            [8, 'timeline', 'Timeline', 'Línea de tiempo', 'সময়রেখা', 'Chronologie'],
            [8, 'Parent_Guardian_Details', 'Parent / Guardian Details', 'Detalles de padres / tutores', 'পিতামাতার / অভিভাবকের বিবরণ', 'Détails sur le parent / tuteur'],
            [8, 'full_marks', 'Full Marks', 'La máxima puntuación', 'পুরো চিহ্ন', 'La totalité des points'],
            [8, 'results', 'Results', 'Resultados', 'ফলাফল', 'Résultats'],
            [8, 'auto_marking', 'Auto marking', 'Auto marking', 'Auto marking', 'Auto marking'],
            [8, 'make_default', 'Make Default', 'Make Default', 'Make Default', 'Make Default'],
            [8, 'negative_marking', 'Negative Marking', 'Negative Marking', 'Negative Marking', 'Negative Marking'],
            [8, 'submit_from_last_page', 'Submit Only From Last Page', 'Submit Only From Last Page', 'Submit Only From Last Page', 'Submit Only From Last Page'],
            [8, 'visible_to_this_person', 'Visible to this person', 'Visible para esta persona', 'এই ব্যক্তির কাছে দৃশ্যমান', 'Visible à cette personne'],
            [9, 'academics', 'Academics', 'Académica', 'শিক্ষাবিদগণ', 'Les universitaires'],
            [9, 'class_routine', 'Class Routine', 'Rutina de clase', 'ক্লাস রুটিন', 'Routine de classe'],
            [9, 'class_routine_create', 'Class Routine Create', 'Rutina de clase Crear', 'ক্লাস রুটিন তৈরি করুন', 'Classe Routine Create'],
            [9, 'view_teacher_routine', 'View Class Routine(Teacher)', 'Ver la rutina de la clase (profesor)', 'দেখুন ক্লাসের রুটিন (শিক্ষক)', 'Voir la routine de classe (enseignant)'],
            [9, 'assign_subject', 'Assign Subject', 'Asignar Asunto', 'সাবজেক্ট বরাদ্দ করুন', 'Attribuer un sujet'],
            [9, 'assign_subject_create', 'Assign Subject create', 'Asignar Asunto crear', 'সাবজেক্ট তৈরি বরাদ্দ করুন', 'Assigner le sujet créer'],
            [9, 'assign_class_teacher', 'Assign Class Teacher', 'Asignar profesor de clase', 'শ্রেণি শিক্ষক নিয়োগ করুন', 'Attribuer un enseignant de classe'],
            [9, 'subjects', 'Subjects', 'Asignaturas', 'বিষয়', 'Sujets'],
            [9, 'class', 'Class', 'Clase', 'শ্রেণী', 'Classe'],
            [9, 'section', 'Section', 'Seccion', 'অধ্যায়', 'Section'],
            [9, 'class_room', 'Class Room', 'Salón de clases', 'ক্লাস রুম', 'Salle de cours'],
            [9, 'n_a', 'N/A', 'N / A', 'এন / এ', 'N / A'],
            [9, 'class_teacher', 'Class Teacher', 'Profesor de la clase', 'শ্রেণী শিক্ষক', 'Professeur de classe'],
            [9, 'assign_teacher', 'Assign Teacher', 'Asignar maestro', 'শিক্ষক নিয়োগ করুন', 'Assigner un enseignant'],
            [9, 'subject_name', 'Subject Name', 'Nombre del tema', 'বিষয় নাম', 'Nom du sujet'],
            [9, 'theory', 'Theory', 'Teoría', 'তত্ত্ব', 'Théorie'],
            [9, 'practical', 'Practical', 'Práctico', 'ব্যবহারিক', 'Pratique'],
            [9, 'subject_code', 'Subject Code', 'Código del Asunto', 'বিষয় কোড', 'Code de sujet'],
            [9, 'subject_type', 'Subject Type', 'Tipo de asunto', 'বিষয় প্রকার', 'Type de sujet'],
            [9, 'capacity', 'Capacity', 'Capacidad', 'ধারণক্ষমতা', 'Capacité'],
            [9, 'cl_ex_time_setup', 'Cl/Ex Time Setup', 'Cl / Ex Configuración de hora', 'সিএল / প্রাক্তন সময় সেটআপ', 'Configuration de lheure Cl / Ex'],
            [9, 'class_exam_time_setup', 'Class & Exam Time Setup', 'Configuración de clase y tiempo de examen', 'ক্লাস ও পরীক্ষার সময় সেটআপ', 'Configuration du temps de cours et dexamen'],
            [9, 'class_time', 'Class Time', 'Hora de clase', 'ক্লাস টাইম', 'Le moment daller en classe'],
            [9, 'time_type', 'Time Type', 'Tipo de tiempo', 'সময়ের ধরণ', 'Type de temps'],
            [9, 'exam_time', 'Exam Time', 'Tiempo de examen', 'পরীক্ষার সময়', 'Temps dexamen'],
            [9, 'period', 'Period', 'Período', 'কাল', 'Période'],
            [9, 'select_time', 'Select Time', 'Seleccione tiempo', 'সময় নির্বাচন করুন', 'Sélectionnez lheure'],
            [9, 'not_assigned_yet', 'Not assigned yet', 'Aún no asignado', 'এখনও নিযুক্ত করা হয়নি', 'Pas encore assigné'],
            [9, 'of', 'of', 'of', 'এর', 'of'],
            [9, 'about', 'About', 'About', 'সম্পর্কিত', 'About'],
            [9, 'payable', 'Payable', 'Payable', 'প্রদেয়', 'Payable'],
            [9, 'start', 'Start', 'Start', 'শুরু করুন', 'Start'],
            [9, 'end', 'End', 'End', 'শেষ', 'End'],
            [9, 'uqinue_fine_list', 'Uqinue Fine List', 'Uqinue fine list', 'অনন্য ফাইন তালিকা', 'Uqinue fine list'],
            [9, 'days_after_date', 'Days After Due Date', 'Days After Due Date', 'নির্ধারিত তারিখের পরে দিনগুলি', 'Days After Due Date'],
            [9, 'fixed', 'Fixed', 'Fixed', 'স্থির', 'Fixed'],
            [9, 'ltl_rtl', 'LTL To RTL', 'LTL To RTL', 'আরটিএল থেকে এলটিএল', 'LTL To RTL'],
            [9, 'testimonial_list', 'Testimonial List', 'Testimonial List', 'প্রশংসাপত্র তালিকা', 'Testimonial List'],
            [9, 'assign_optional_subject', 'Assign Optional Subject', 'Assign Optional Subject', 'বরাদ্দ ঐচ্ছিক বিষয়', 'Assign Optional Subject'],
            [9, 'term_wise_report', 'Term Wise Report', 'Term Wise Report', 'টার্ম ওয়াইজ রিপোর্ট', 'Term Wise Report'],
            [9, 'type_wise_report', 'Type Wise Report', 'Type Wise Report', 'টাইপ ওয়াইজ রিপোর্ট', 'Type Wise Report'],
            [9, 'due_wise_report', 'Due Wise Report', 'Due Wise Report', 'বুদ্ধিমান প্রতিবেদন', 'Due Wise Report'],
            [9, 'contract_type', 'Contract Type', 'Contract Type', 'চুক্তির ধরণ', 'Contract Type'],
            [9, 'verify', 'Verify', 'Verify', 'যাচাই করুন', 'Verify'],
            [9, 'addOns', 'Add Ons', 'Add Ons', 'অন যোগ করুন', 'Add Ons'],
            [9, 'adons', 'Add Ons', 'Add Ons', 'অন যোগ করুন', 'Add Ons'],
            [0, 'export', 'Export', 'Export', 'রফতানি', 'Export'],
            [0, 'biometrics', 'Biometrics', 'Biometrics', 'বায়োমেট্রিক্স', 'Biometrics'],
            [0, 'bio', 'Biometrics', 'Biometrics', 'বায়োমেট্রিক্স', 'Biometrics'],
            [0, 'buy', 'Buy', 'Buy', 'কেনা', 'Buy'],
            [0, 'csu', 'Custom URL', 'Custom URL', 'কাস্টম ইউআরএল', 'Custom URL'],
            [0, 'now', 'Now', 'Now', 'এখন', 'Now'],
            [19, 'social_media', 'Social Media', 'Social Media', 'সামাজিক মাধ্যম', 'Social Media'],
            [19, 'icon', 'Icon', 'Icon', 'আইকন', 'Icon'],
            [3, 'student_delete_note', 'Note: if delete, then all related information will removed.', 'Note: if delete, then all related information will removed.', 'দ্রষ্টব্য: যদি মুছে ফেলা হয়, তবে সম্পর্কিত সমস্ত তথ্য মুছে ফেলা হবে।', 'Note: if delete, then all related information will removed.'],
            [6, 'staff_delete_note', 'Note: if delete, then all related information will removed.', 'Note: if delete, then all related information will removed.', 'দ্রষ্টব্য: যদি মুছে ফেলা হয়, তবে সম্পর্কিত সমস্ত তথ্য মুছে ফেলা হবে।', 'Note: if delete, then all related information will removed.'],
            [17, 'cumulative', 'Cumulative', 'cumulative', 'ক্রমবর্ধমান', 'cumulative'],
            [17, 'sheet', 'Sheet', 'sheet', 'চাদর', 'sheet'],
            [17, 'contonuous', 'Contonuous', 'contonuous', 'একটানা', 'contonuous'],
            [17, 'assessment', 'Assessment', 'assessment', 'মূল্যায়ন', 'assessment'],
            [17, 'termly', 'Termly', 'Termly', 'স্থায়ীভাবে', 'Termly'],
            [17, 'academic', 'Academic', 'Academic', 'একাডেমিক', 'Academic'],
            [17, 'performance', 'Performance', 'Performance', 'কর্মক্ষমতা', 'Performance'],
            [17, 'terminal', 'Terminal', 'Terminal', 'টার্মিনাল', 'Terminal'],
            [17, 'continuous', 'Continuous', 'Continuous', 'একটানা', 'Continuous'],
            [17, 'institution', 'Institution', 'Institution', 'প্রতিষ্ঠান', 'Institution'],
            [17, 'one', 'One', 'one', 'এক', 'one'],
            [17, 'school', 'School', 'School', 'বিদ্যালয়', 'School'],
            [17, 'opening', 'Opening', 'opening', 'খোলার', 'opening'],
            [17, 'confirm_password', 'Confirm Password', 'confirm password', 'পাসওয়ার্ড নিশ্চিত করুন', 'confirm password'],
            [17, 'or', 'or', 'or', 'বা', 'or'],
            [17, 'routine', 'Routine', 'Routine', 'রুটিন', 'Routine'],
            [17, 'ticket_comment', 'Ticket Comment', 'Ticket Comment', 'টিকিট মন্তব্য', 'Ticket Comment'],
            [17, 'my', 'My', 'my', 'আমার', 'my'],
            [17, 'ticket', 'Ticket', 'ticket', 'টিকিট', 'ticket'],
            [17, 'guardian_mobile', 'Guardian Mobile', 'guardian mobile', 'গার্ডিয়ান মোবাইল', 'guardian mobile'],
            [17, 'is_approved', 'Is Approved', 'is approved', 'অনুমোদিত হয়', 'is approved'],
            [17, 'is_enabled', 'Is Enabled', 'Is Enabled', 'সক্রিয় করা হয়', 'Is Enabled'],
            [17, 'ticket_list', 'Ticket List', 'Ticket List', 'টিকিটের তালিকা', 'Ticket List'],
            [17, 'priority_list', 'Priority List', 'Priority List', 'অগ্রাধিকার তালিকা', 'Priority List'],
            [17, 'ticket_priority', 'Ticket Priority', 'Ticket Priority', 'টিকিট অগ্রাধিকার', 'Ticket Priority'],
            [17, 'ticket_category', 'Ticket Category', 'Ticket Category', 'টিকিট বিভাগ', 'Ticket Category'],
            [17, 'category_list', 'Category List', 'Category List', 'বিভাগ তালিকা', 'Category List'],
            [17, 'ticket_system', 'Ticket System', 'Ticket System', 'টিকিট সিস্টেম', 'Ticket System'],
            [17, 'delete_uploaded_content', 'Delete Uploaded Content', 'Delete Uploaded Content', 'আপলোড করা সামগ্রী মুছুন', 'Delete Uploaded Content'],
            [17, 'add_content', 'Add Content', 'Add Content', 'সামগ্রী যুক্ত করুন', 'Add Content'],

            [18, 'download_uploaded_content', 'Download Uploaded Content', 'Download Uploaded Content', 'আপলোড করা সামগ্রী ডাউনলোড করুন', 'Download Uploaded Content'],

            [18, 'password_reset_message', 'Password Reset Message', 'Password Reset Message', 'পাসওয়ার্ড রিসেট বার্তা', 'Password Reset Message'],

            [18, 'student_login_credential_message', 'Student Login Credential Message', 'Student Login Credential Message', 'ছাত্র লগইন শংসাপত্র বার্তা', 'Student Login Credential Message'],

            [18, 'guardian_login_credential_message', 'Guardian Login Credential Message', 'Guardian Login Credential Message', 'অভিভাবক লগইন শংসাপত্র বার্তা', 'Guardian Login Credential Message'],

            [18, 'staff_login_credential_message', 'Staff Login Credential Message', 'Staff Login Credential Message', 'স্টাফ লগইন শংসাপত্র বার্তা', 'Staff Login Credential Message'],

			[18, 'dues_payment_message', 'Dues Payment Message', 'Dues Payment Message', 'বকেয়া অর্থ প্রদানের বার্তা', 'Dues Payment Message'],         
			[18, 'email_footer_text', 'Email Footer Text', 'Email Footer Text', 'ইমেল পাদলেখ পাঠ্য', 'Email Footer Text'],
			[18, 'registration', 'Registration', 'Registration', 'নিবন্ধন', 'Registration'],
			[18, 'after', 'After', 'After', 'পরে', 'After'],
			[18, 'header', 'Header', 'Header', 'শিরোনাম', 'Header'],
			[18, 'footer', 'Footer', 'Footer', 'পাদচরণ', 'Footer'],
			[18, 'footer_widget', 'Footer Widget', 'Footer Widget', 'পাদচরণ উইজেট', 'Footer Widget'],
			[18, 'sec', 'Section', 'Section', 'অধ্যায়', 'Section'],
			[18, 'are_you_sure_to_approve', 'Are You Sure To Approve This Item?', 'Are you sure to approve this item?', 'আপনি কি এই আইটেমটি অনুমোদনের বিষয়ে নিশ্চিত?', 'Are you sure to approve this item?'],
			[18, 'saas', 'SAAS', 'SAAS ', 'সাস', 'SAAS'],
			[18, 'owner', 'Owner', 'Owner ', 'মালিক', 'Owner'],
			[18, 'priority', 'Priority', 'Priority ', 'অগ্রাধিকার', 'Priority'],
			[18, 'responsible', 'Responsible', 'Responsible ', 'দায়বদ্ধ', 'Responsible'],
			[18, 'reply', 'Reply', 'Reply ', 'উত্তর', 'Reply'],
			[18, 'reply_here', 'Reply Here', 'Reply Here ', 'সমর্থন', 'Reply Here'],
			[18, 'support', 'Support', 'Support ', 'এখানে উত্তর দিন', 'Support'],
			[18, 'how_do_you_know_us', 'How Do You Know Us', 'How Do You Know Us', 'আপনি আমাদের জানেন কিভাবে', 'How Do You Know Us'],
			[18, 'recaptcha', 'Recaptcha', 'Recaptcha', 'পুনঃপচা', 'Recaptcha'],
			[18, 'nocaptcha_sitekey', 'noCaptcha Sitekey', 'noCaptcha Sitekey', 'নো ক্যাপচা সাইট কি', 'noCaptcha Sitekey'],
			[18, 'nocaptcha_secret', 'noCaptcha Secret', 'noCaptcha Secret', 'নো ক্যাপচা গোপন', 'noCaptcha Secret'],
			[18, 'guardian_relation', 'Guardian Relation', 'Guardian Relation', 'অভিভাবক সম্পর্কিত', 'Guardian Relation'],
			[18, 'relation', 'Relation', 'Relation', 'সম্পর্ক', 'Relation'],
			[18, 'promossion_without', 'Promotion Without', 'Promotion Without', 'প্রচার ছাড়াই', 'Promotion Without'],
			[18, 'promossion', 'Promotion', 'Promotion', 'পদোন্নতি', 'Promotion'],
			[18, 'administrator', 'Administrator', 'Administrator', 'প্রশাসক', 'Administrator'],
			[18, 'age', 'Age', 'Age', 'বয়স', 'Age'],
			[18, 'note_for_multiple_child_registration', 'If you want to register your another child please contact with school.', 'If you want to register your another child please contact with school.', 'আপনি যদি আপনার অন্য সন্তানের নিবন্ধন করতে চান তবে দয়া করে স্কুলের সাথে যোগাযোগ করুন।', 'If you want to register your another child please contact with school.'],
			[18, 'click_for_recaptcha_create', 'Click Here For Create Recaptcha (v2).', 'Click Here For Create Recaptcha (v2)', 'পুনর্নির্মাণ তৈরি করার জন্য এখানে ক্লিক করুন (v2)', 'Click Here For Create Recaptcha (v2)'],
			[18, 'textlocal', 'Textlocal', 'Textlocal', 'পাঠ্যপুস্তক', 'Textlocal'],
			[18, 'hash', 'Hash', 'Hash', 'হ্যাশ', 'Hash'],
            [18, 'sms_template', 'Email/Sms Template', 'Email/Sms Template', 'এসএমএস টেম্পলেট', 'Email/Sms Template'],

            [18, 'zoom', 'Zoom', 'Zoom', 'জুম', 'Zoom'],
            [18, 'virtual_class', 'Virtual Class', 'Virtual Class', 'ভার্চুয়াল ক্লাস', 'Virtual Class'],
            [18, 'not_permitted', 'Not Permitted', 'Not Permitted', 'অননুমোদিত', 'Not Permitted'],
      
            [18, 'description', 'Description', 'Description', 'বিবরণ', 'Description'],
            [18, 'date_of_meeting', 'Date of Meeting', 'Date of Meeting', 'সভার তারিখ', 'Date of Meeting'],
            [18, 'time_of_meeting', 'Time of Meeting', 'Time of Meeting', 'সভার সময়', 'Time of Meeting'],
            [18, 'meeting_durration', 'Meetting Durration (Minutes)', 'Meetting Durration (Minutes)', 'সভার সময়কাল (মিনিট)', 'Meetting Durration (Minutes)'],
            [18, 'zoom_recurring', 'Recurring', 'Recurring', 'পুনরাবৃত্তি', 'Recurring'],
            [18, 'zoom_recurring_type', 'Recurrence Type', 'Recurrence Type', 'পুনরাবৃত্তির ধরণ', 'Recurrence Type'],
            [18, 'zoom_recurring_daily', 'Daily', 'Daily', 'প্রতিদিন', 'Daily'],
            [18, 'zoom_recurring_weekly', 'Weekly', 'Weekly', 'সাপ্তাহিক', 'Weekly'],
            [18, 'zoom_recurring_monthly', 'Monthly', 'Monthly', 'মাসিক', 'Monthly'],
            [18, 'zoom_recurring_repect', 'Repeat Every', 'Repeat Every', 'প্রতিটি পুনরাবৃত্তি', 'Repeat Every'],
            [18, 'repeat', 'Repeat', 'Repeat', 'পুনরাবৃত্তি', 'Repeat'],
            [18, 'zoom_recurring_end', 'End Recurrence', 'End Recurrence', 'শেষ পুনরাবৃত্তি', 'End Recurrence'],
            [18, 'join_before_host', 'Join Before Host', 'Join Before Host', 'হোস্টের আগে যোগ দিন', 'Join Before Host'],
            [18, 'host_video', 'Host Video', 'Host Video ', 'হোস্ট ভিডিও', 'Host Video'],
            [18, 'participant_video', 'Participant Video', 'Participant Video', 'অংশগ্রহণকারী ভিডিও', 'Participant Video'],
            [18, 'mute_upon_entry', 'Participate Mic Mute', 'Participate Mic Mute ', 'মাইক নিঃশব্দে অংশ নিন', 'Participate Mic Mute'],
            [18, 'watermark', 'Watermark', 'Watermark', 'ওয়াটারমার্ক', 'Watermark'],
            [18, 'waiting_room', 'Waiting Room', 'Waiting Room', 'বিশ্রাম কক্ষ', 'Waiting Room'],
            [18, 'auto_recording', 'Auto Recording', 'Auto Recording', 'অটো রেকর্ডিং', 'Auto Recording'],
            [18, 'audio_options', 'Audio Option', 'Audio Option', 'অডিও বিকল্প', 'Audio Option'],
            [18, 'meeting_approval', 'Meeting Join Approval', 'Meeting Join Approval', 'সভা যোগদানের অনুমোদন', 'Meeting Join Approval'],
            [18, 'meeting_id', 'Meeting ID', 'Meeting ID', 'মিটিং আইডি', 'Meeting ID'],
            [18, 'zoom_start_join', 'Join/Start', 'Join/Start', 'যোগ দিন / শুরু করুন', 'Join/Start'],
            [18, 'join', 'Join', 'Join', 'যোগদান', 'Join'],
            [18, 'show', 'Show', 'Show', 'দেখান', 'Show'],
            [18, 'delete_meetings', 'Delete Meeting', 'Delete Meeting', 'সভা মুছুন', 'Delete Meeting'],
            [18, 'are_you_sure_delete', 'Are You Sure To Delete ?', 'Are you sure to delete ?', 'আপনি কি মুছে ফেলার বিষয়ে নিশ্চিত?', 'Are you sure to delete ?'],
            [18, 'are_you_sure_to', 'Are You Sure To', 'Are you sure to', 'আপনি কি  নিশ্চিত?', 'Are you sure to'],
            [18, 'zoom_setting', 'Zoom Setting', 'Zoom Setting', 'জুম সেটিং', 'Zoom Setting'],
            [18, 'automatically', 'Automatically', 'Automatically', 'স্বয়ংক্রিয়ভাবে', 'Automatically'],
            [18, 'manually', 'Manually', 'Manually', 'ম্যানুয়ালি', 'Manually'],
            [18, 'required', 'Required', 'Required', 'প্রয়োজনীয়', 'Required'],
            [18, 'local', 'Local', 'Local', 'স্থানীয়', 'Local'],
            [18, 'cloud', 'Cloud', 'Cloud', 'মেঘ', 'Cloud'],
            [18, 'both', 'Both', 'Both', 'দুটোই', 'Both'],
            [18, 'telephony', 'Telephony', 'Telephony', 'টেলিফোনি', 'Telephony'],
            [18, 'voip', 'Voip', 'Voip', 'ভিওআইপি', 'Voip'],
            [18, 'basic', 'Basic', 'Basic', 'বেসিক', 'Basic'],
            [18, 'free', 'Free', 'Free', 'ফ্রি', 'Free'],
            [18, 'pro', 'Pro', 'Pro', 'প্রো', 'Pro'],
            [18, 'preview', 'Preview', 'Preview', 'পূর্বরূপ', 'Preview'],
            [18, 'business', 'Business', 'Business', 'ব্যবসা', 'Business'],
            [18, 'enterprise', 'Enterprise', 'Enterprise', 'এন্টারপ্রাইজ', 'Enterprise'],
            [18, 'for_paid_package', 'For Paid Package', 'For Paid Package', 'পেইড প্যাকেজের জন্য', 'For Paid Package'],
            [18, 'api_key', 'API Key', 'API Key', 'এপিআই কী', 'API Key'],
            [18, 'serect_key', 'Secret Key', 'Secret Key', 'গোপন চাবি', 'Secret Key'],
            [18, 'pakage', 'Pakage', 'Pakage', 'পাকেজ', 'Pakage'],
            [18, 'join_meeting', 'Join Meeting', 'Join Meeting', 'সভাতে যোগদান করুন', 'Join Meeting'],
            [18, 'attached_file', 'Attached File', 'Attached File', 'সংযুক্ত ফাইল', 'Attached File'],
            [18, 'start_date_time', 'Start Date & Time', 'Start Date & Time', 'আরম্ভের তারিখ ও সময়', 'Start Date & Time'],
            [18, 'not_yet_start', 'Not Yet Start', 'Not Yet Start', 'এখনও না শুরু', 'Not Yet Start'],
            [18, 'closed', 'Closed', 'closed', 'বন্ধ', 'closed'],
            [18, 'host_id', 'Host ID', 'Host ID', 'হোস্ট আইডি', 'Host ID'],
            [18, 'timezone', 'Timezone', 'Timezone', 'সময় অঞ্চল', 'Timezone'],
            [18, 'created_at', 'Created At', 'Created At', 'এ নির্মিত', 'Created At'],
            [18, 'join_url', 'Join URL', 'Join URL', 'ইউআরএল যোগ দিন', 'Join URL'],
            [18, 'encrypted', 'Encrypted', 'Encrypted', 'এনক্রিপ্ট করা', 'Encrypted'],
            [18, 'in_mettings', 'in Mettings', 'in Mettings', 'মিটিংয়ে', 'in Mettings'],
            [18, 'cn_mettings', 'cn Mettings', 'cn Mettings', 'সিএন সভা', 'cn Mettings'],
            [18, 'use_pmi', 'use pmi', 'use pmi', 'পিএমআই ব্যবহার করুন', 'use pmi'],
            [18, 'enforce_login', 'Enforce Login', 'Enforce Login', 'লগইন প্রয়োগ করুন', 'Enforce Login'],
            [18, 'enforce_login_domains', 'Enforce Login Domains', 'Enforce Login Domains', 'লগইন ডোমেনগুলি প্রয়োগ করুন', 'Enforce Login Domains'],
            [18, 'alternative_hosts', 'Alternative Hosts', 'Alternative Hosts', 'প্রমাণীকরণের সভা', 'Alternative Hosts'],
            [18, 'meeting_authentication', 'Meeting Authentication', 'Meeting Authentication', 'প্রমাণীকরণের সভা', 'Meeting Authentication'],
            [18, 'delete_virtual_meeting', 'Delete Virtaul Meeting', 'Delete Virtaul Meeting', 'ভার্চুয়াল সভা মুছুন', 'Delete Virtaul Meeting'],
            [18, 'delete_virtual_class', 'Delete Virtaul Class', 'Delete Virtaul Class', 'ভার্চুয়াল ক্লাস মুছুন', 'Delete Virtaul Class'],
            [18, 'meeting', 'Meeting', 'Meeting', 'সভা', 'Meeting'],
            [18, 'join_class', 'Join Class', 'Join Class', 'ক্লাসে যোগদান করুন', 'Join Class'],
            [18, 'participants', 'Participants', 'Participants', 'অংশগ্রহণকারীরা', 'Participants'],
            [18, 'meetings', 'Meetings', 'Meetings', 'সভা', 'Meetings'],
            [18, 'select_member', 'Select Member', 'Select Member', 'সদস্য নির্বাচন করুন', 'Select Member'],
            [18, 'change_default_settings', 'Change Default Settings', 'Change Default Settings', 'ডিফল্ট সেটিংস পরিবর্তন করুন', 'Change Default Settings'],
            [18, 'virtual_class_meetting', 'Vitual Class/Meeting', 'Vitual Class/Meeting', 'ভার্চুয়াল ক্লাস / সভা', 'Vitual Class/Meeting'],
            [18, 'class_reports', 'Class Reports', 'Class Reports', 'ক্লাস রিপোর্ট', 'Class Reports'],
            [18, 'meeting_reports', 'Meeting Reports', 'Meeting Reports', 'সভা সভা', 'Meeting Reports'],
            [18, 'date_of_class', 'Date of Class', 'Date of Class', 'ক্লাসের তারিখ', 'Date of Class'],
            [18, 'time_of_class', 'Time of Class', 'Time of Class', 'ক্লাসের সময়', 'Time of Class'],
            [18, 'duration_of_class', 'Duration of Class (Minutes)', 'Duration of Class (Minutes)', 'শ্রেণীর সময়কাল (মিনিট)', 'Duration of Class (Minutes)'],
            [18, 'virtual_class_id', 'VClass ID', 'VClass ID', 'ভিস্লাস আইডি', 'VClass ID'],
            [18, 'virtual_meeting', 'Virtual Meeting', 'Virtual Meeting', 'ভার্চুয়াল সভা', 'Virtual Meeting'],

            [18, 'sms_template', 'Sms Template', 'Sms Template', 'এসএমএস টেম্পলেট', 'Sms Template'],
            [18, 'liability', 'Liability', 'Liability', 'দায়', 'Liability'],
            [18, 'asset', 'Asset', 'Asset', 'সম্পদ', 'Asset'],
            [18, 'bank_details', 'Bank Details', 'Bank Details', 'ব্যাংক বিবরণ', 'Bank Details'],
            [18, 'africatalking', 'Africatalking', 'Africatalking', 'আফ্রিকান কথাবার্তা', 'Africatalking'],
            [18, 'africatalking_api_key', 'Africatalking API Key', 'Africatalking API Key', 'আফ্রিকানতালিকা এপিআই কী', 'Africatalking API Key'],
            [18, 'slip', 'Slip', 'Slip', 'স্লিপ', 'Slip'],
            [18, 'class_time_setup', 'Class Time Setup', 'Class Time Setup', 'ক্লাস টাইম সেটআপ', 'Class Time Setup'],
            [18, 'result_not_publish_yet', 'Result Not Publish Yet', 'Result Not Publish Yet', 'ফলাফল এখনও প্রকাশ হয় না', 'Result Not Publish Yet'],
            [18, 'max_upload_file_size', 'Max Upload File Size', 'Max Upload File Size', 'সর্বোচ্চ ফাইল আপলোড', 'Max Upload File Size'],

            
            [18, 'gateway_setting', 'Gateway Setting', 'Gateway Setting', 'গেটওয়ে সেটিং', 'Gateway Setting'],
            [18, 'ss_page_load', 'Server Side Page Load', 'Server Side Page Load', 'সার্ভার সাইড পৃষ্ঠা লোড', 'Server Side Page Load'],

            [18, 'cheque_details', 'Cheque Details', 'Cheque Details', 'বিশদ পরীক্ষা করুন', 'Cheque Details'],
            [18, 'event_ist', 'Event List', 'Event List', 'ইভেন্ট তালিকা', 'Event List'],
            [18, 'incorrect', 'Incorrect', 'Incorrect', 'ভুল', 'Incorrect'],
            [18, 'browse_all', 'Browse All', 'Browse All', 'সমস্ত ব্রাউজ করুন', 'Browse All'],
            [18, 'notice_board', 'Notice Board', 'Notice Board', 'সমস্ত ব্রাউজ করুন', 'Notice Board'],
            [18, 'related_news', 'Related News', 'Related News', 'সম্পর্কিত খবর', 'Related News'],
            [18, 'related_courses', 'Related Courses', 'Related Courses', 'সম্পর্কিত কোর্স', 'Related Courses'],
            [18, 'latest_news', 'Latest News', 'Latest News', 'সর্বশেষ সংবাদ', 'Latest News'],
            [18, 'load_more_news', 'Load More News', 'Load More News', 'সর্বশেষ সংবাদ', 'Load More News'],
            [18, 'Opened_in', 'Opened in', 'Opened in', 'ভিতরে খোলা', 'Opened in'],
            [18, 'Total_Teachers_count', 'Total Teachers count', 'Total Teachers count', 'মোট শিক্ষক গণনা', 'Total Teachers count'],
            [18, 'Faculty', 'Faculty', 'Faculty', 'অনুষদ', 'Faculty'],
            [18, 'Our_History', 'Our History', 'Our History', 'আমাদের ইতিহাস', 'Our History'],
            [18, 'Enter_your', 'Enter your', 'Enter your', 'প্রবেশ করাও তোমার', 'Enter your'],
            [18, 'our_mission', 'Our Mission and Vision', 'Our Mission and Vision', 'আমাদের মিশন এবং দৃষ্টি', 'Our Mission and Vision'],
            [18, 'load_more_courses', 'Load More Courses', 'Load More Courses', 'আরও কোর্স লোড করুন', 'Load More Courses'],
            [18, 'Auto_Mark_Register', 'Auto Mark Register', 'Auto Mark Register', 'অটো চিহ্ন নিবন্ধ', 'Auto Mark Register'],
            [18, 'Only_for_Multiple', 'Only for Multiple choise & True False', 'Only for Multiple choise & True False', 'শুধুমাত্র একাধিক পছন্দ এবং সত্য মিথ্যা জন্য', 'Only for Multiple choise & True False'],
            [18, 'logo', 'Logo', 'Logo', 'লোগো', 'Logo'],
            [18, 'map', 'Map', 'Map', 'মানচিত্র', 'Map'],
            [18, 'text', 'Text', 'Text', 'পাঠ্য', 'Text'],
            [18, 'user_management', 'User Management', 'User Management', 'ব্যবহারকারী ব্যবস্থাপনা', 'User Management'],
            [18, 'is_read?', 'Is Read?', 'Is Read?', 'পড়া আছে?', 'Is Read?'],
            [18, 'is_replied?', 'Is Replied?', 'Is Replied?', 'জবাব দেওয়া হয়?', 'Is Replied?'],
            [18, 'latitude', 'Latitude', 'Latitude', 'অক্ষাংশ', 'Latitude'],
            [18, 'longitude', 'Longitude', 'Longitude', 'দ্রাঘিমাংশ', 'Longitude'],
            [18, 'signiture', 'Signiture', 'Signiture', 'স্বাক্ষর', 'Signiture'],
            [18, 'import_attendance', 'Import Attendance', 'Import Attendance', 'আমদানি উপস্থিতি', 'Import Attendance'],
            [18, 'cheque_details', 'Cheque Details', 'Cheque Details', 'বিশদ পরীক্ষা করুন', 'Cheque Details'],
            [18, 'copy_with_academic_year', 'Copy With Academic Year', 'Copy With Academic Year', 'একাডেমিক বছর সহ অনুলিপি করুন', 'Copy With Academic Year'],
            [18, 'delete_conformation', 'All the information related with this data will also delete permanently', 'All the information related with this data will also delete permanently', 'এর সাথে সম্পর্কিত সমস্ত তথ্যও স্থায়ীভাবে মুছে ফেলা হবে', 'All the information related with this data will also delete permanently'],
            [18, 'academic_year_delete_confirmation', 'All the information related with this academic year will also delete permanently.', 'All the information related with this academic year will also delete permanently.', 'এই শিক্ষাবর্ষের সাথে সম্পর্কিত সমস্ত তথ্যও স্থায়ীভাবে মুছে ফেলা হবে', 'All the information related with this academic year will also delete permanently.'],
            [18, 'system_activation_date', 'System Activation Date', 'System Activation Date', 'সিস্টেম সক্রিয়করণের তারিখ', 'System Activation Date'],
            [18, 'install_domain', 'Install Domain', 'Install Domain', 'ডোমেন ইনস্টল করুন', 'Install Domain'],
            [18, 'purchase_code', 'Purchase code', 'Purchase code', 'ক্রয় কোড', 'Purchase code'],
            [18, 'curl_enable', 'Curl enable', 'Curl enable', 'কার্ল সক্ষম', 'Curl enable'],
            [18, 'PHP_version', 'PHP Version', 'PHP Version', 'পিএইচপি সংস্করণ', 'PHP Version'],
            [18, 'check_update', 'Check update', 'Check update', 'আপডেট চেক কর', 'Check update'],
            [18, 'software_version', 'Software Version', 'Software Version', 'সফ্টওয়্যার সংস্করণ', 'Software Version'],
            [0, 'lesson', 'Lesson', 'Lesson', 'পাঠ', 'Lesson'],
            [0, 'plan', 'Plan', 'Plan', 'পরিকল্পনা', 'Plan'],
            [0, 'sup', 'Sup', 'Sup', 'উপ', 'Sup'],
            [19, 'sub', 'Sub', 'Sub', 'উপ', 'Sub'],
            [0, 'lesson_plan', 'Lesson Plan', 'Lesson Plan', 'পাঠ পরিকল্পনা', 'Lesson Plan'], 
            [0, 'lesson_plan_overview', 'Lesson Plan Overview', 'Lesson Plan Overview', 'পাঠ পরিকল্পনা বিবরণ', 'Lesson Plan Overview'], 
            [0, 'sup_topic', 'Sup Topic', 'Sup Topic', 'উপ বিষয়', 'Sup Topic'], 
            [1, 'overview', 'Overview', 'Overview', 'সংক্ষিপ্ত বিবরণ', 'Overview'],
            [0, 'topic_overview', 'Topic Overview', 'Topic Overview', 'বিষয় বিবরণ', 'Topic Overview'], 
            [16, 'progress', 'Progress', 'Progreso', 'অগ্রগতি', 'Progression'],
            [16, 'upcoming', 'Upcoming', 'Upcoming', 'আসন্ন', 'Upcoming'],
            [19, 'teaching', 'Teaching', 'Teaching', 'শিক্ষাদান', 'Teaching'],
            [19, 'general', 'General', 'General', 'সাধারণ', 'General'],
            [19, 'objectives', 'Objectives', 'Objectives', 'উদ্দেশ্য', 'Objectives'],
            [19, 'knowledge', 'Knowledge', 'Knowledge', 'জ্ঞান', 'Knowledge'],
            [19, 'comprehensive', 'Comprehensive', 'Comprehensive', 'বিস্তৃত', 'Comprehensive'],
            [19, 'lecture', 'Lecture', 'Lecture', 'লেকচার', 'Lecture'],
            [19, 'youtube', 'YouTube', 'YouTube', 'ইউটিউব', 'YouTube'],
            [19, 'multiple', 'Multiple', 'Multiple', 'একাধিক', 'Multiple'],
            [19, 'separate', 'Separate', 'Separate', 'পৃথক', 'Separate'],
            [16, 'online_exam_result', 'Online Exam Result', 'Informe de examen en línea', 'অনলাইন পরীক্ষার ফলাফল', 'Result dexamen en ligne'],
            [0, 'my_lesson_plan', 'My Lesson Plan', 'My Lesson Plan', 'আমার পাঠ পরিকল্পনা', 'My Lesson Plan'], 
            [0, 'my_lesson_plan_overview', 'My Lesson Plan Overview', 'My Lesson Plan Overview', 'আমার পাঠ পরিকল্পনা বিবরণ', 'My Lesson Plan Overview'], 
            [19, 'download_center', 'Download Center', 'Centro de descargas', 'ডাউনলোড কেন্দ্র', 'centre de téléchargement'],
            [14, 'student_teacher', 'Student Teacher', 'Informe de teacher', 'ছাত্র শিক্ষক', 'student teacher'],
            [14, 'bbb', 'BigBlueButton', 'BigBlueButton', 'বিগব্লু বাটন', 'BigBlueButton'], 
            [14, 'dial_number', 'Dial Number', 'Dial Number', 'নম্বর ডায়াল করুন', 'Dial Number'], 
            [14, 'max_participants', 'Max Participants', 'Max Participants', 'সর্বাধিক অংশগ্রহণকারী', 'Max Participants'], 
            [14, 'unlimited', 'Unlimited', 'Unlimited', 'সীমাহীন', 'Unlimited'], 
            [14, 'is_breakout', 'Is Breakout', 'Is Breakout', 'ব্রেকআউট', 'Is Breakout'], 
            [14, 'moderator_only_message', 'Moderator Only Message', 'Moderator Only Message', 'মডারেটর কেবল বার্তা', 'Moderator Only Message'], 
            [14, 'auto_start_recording', 'Auto Start Recording', 'Auto Start Recording', 'অটো স্টার্ট রেকর্ডিং', 'Auto Start Recording'], 
            [14, 'allow_start_stop_recording', 'Allow Start Stop Recording', 'Allow Start Stop Recording', 'স্টপ রেকর্ডিং শুরু করুন', 'Allow Start Stop Recording'], 
            [14, 'webcams_only_for_moderator', 'Webcams Only For Moderator', 'Webcams Only For Moderator', 'ওয়েবক্যামস কেবলমাত্র মডারেটরের জন্য', 'Webcams Only For Moderator'], 
            [14, 'copyright', 'Copyright', 'Copyright', 'কপিরাইট', 'Copyright'], 
            [14, 'mute_on_start', 'Mute On Start', 'Mute On Start', 'শুরুতে নিঃশব্দ করুন', 'Mute On Start'], 
            [14, 'lock_settings_disable_mic', 'Lock Settings Disable Mic', 'Lock Settings Disable Mic', 'লক সেটিংস মাইক অক্ষম করুন', 'Lock Settings Disable Mic'], 
            [14, 'lock_settings_disable_private_chat', 'Lock Settings Disable Private Chat', 'Lock Settings Disable Private Chat', 'লক সেটিংস ব্যক্তিগত চ্যাট অক্ষম করে', 'Lock Settings Disable Private Chat'], 
            [14, 'lock_settings_disable_public_chat', 'Lock Settings Disable Public Chat', 'Lock Settings Disable Public Chat', 'লক সেটিংস পাবলিক চ্যাট অক্ষম করে', 'Lock Settings Disable Public Chat'], 
            [14, 'lock_settings_disable_note', 'Lock Settings Disable Note', 'Lock Settings Disable Note', 'লক সেটিংস অক্ষম করুন', 'Lock Settings Disable Note'], 
            [14, 'lock_settings_locked_layout', 'Lock Settings Locked Layout', 'Lock Settings Locked Layout', 'লক সেটিংস লক লেআউট', 'Lock Settings Locked Layout'], 
            [14, 'lock_settings_lock_on_join', 'Lock Settings Lock On Join', 'Lock Settings Lock On Join', 'যোগদান লক সেটিংস লক অন', 'Lock Settings Lock On Join'], 
            [14, 'lock_settings_lock_on_join_configurable', 'Lock Settings Lock On Join Configurable', 'Lock Settings Lock On Join Configurable', 'লক সেটিংস লক অন জয়েন কনফিগারযোগ্য', 'Lock Settings Lock On Join Configurable'], 
            [14, 'guest_policy', 'Guest Policy', 'Guest Policy', 'অতিথি নীতি', 'Guest Policy'], 
            [14, 'state', 'State', 'State', 'অবস্থা', 'State'], 
            [14, 'always_accept', 'Always Accept', 'Always Accept', 'অতিথি নীতি', 'Always Accept'], 
            [14, 'always_deny', 'Always Deny', 'Always Deny', 'সর্বদা অস্বীকার করুন', 'Always Deny'], 
            [14, 'ask_moderator', 'Ask Moderator', 'Ask Moderator', 'মডারেটর জিজ্ঞাসা করুন', 'Ask Moderator'], 
            [14, 'redirect', 'Redirect', 'Redirect', 'পুনঃনির্দেশ', 'Redirect'], 
            [14, 'join_via_html5', 'Join Via Html 5', 'Join Via Html 5', 'এইচটিএমএল 5 এর মাধ্যমে যোগদান করুন', 'Join Via Html 5'], 
            [14, 'any', 'Any', 'Any', 'যে কোন', 'Any'], 
            [14, 'please_make_sure_bbb_api_key_setup_successfully', 'Please make sure BBB api key setup successfully', 'Please make sure BBB api key setup successfully', 'বিবিবি এপিআই কী সেটআপটি সফলভাবে নিশ্চিত করুন', 'Please make sure BBB api key setup successfully'], 
            [14, 'without_bbb_api_setup_you_can_not_create_class', 'Without BBB api setup you can not create class', 'Without BBB api setup you can not create class', 'বিবিবি এপি সেটআপ ছাড়া আপনি ক্লাস তৈরি করতে পারবেন না', 'Without BBB api setup you can not create class'], 
            [14, 'attendee', 'Attendee', 'Attendee', 'অংশগ্রহণকারী', 'Attendee'], 
            [14, 'password_length', 'Password Length', 'Password Length', 'পাসওয়ার্ড দৈর্ঘ্য', 'Password Length'], 
            [14, 'allow_start_recording', 'Allow Start Recording', 'Allow Start Recording', 'রেকর্ডিং শুরু করার অনুমতি দিন', 'Allow Start Recording'], 
            [6, 'add_student', 'Add Student', 'Añadir Student', 'ছাত্র যোগ করুন', 'Ajouter du Student'],
            [2, 'course_details_heading', 'Course Details Heading', 'Course Details Heading', 'কোর্স বিশদ শিরোনাম', 'Course Details Heading'],
            [2, 'bank_payment', 'Bank Payment', 'Nombre del banco', 'ব্যাংক পেমেন্ট', 'Nom de banque'],
            [0, 'topic', 'Topic', 'Topic', 'বিষয়', 'Topic'], 
            [0, 'before', 'Before', 'antaŭe', 'আগে', 'avant que'], 
            [0, 'waiting', 'Waiting', 'Waiting', 'অপেক্ষায়', 'Waiting'], 
            [9, 'class_recorded_list', 'Class Recorded List', 'Clase Recorded Lista', 'শ্রেণী রেকর্ড তালিকা', 'Classe Recorded liste'],
            [9, 'meeting_recorded_list', 'Meeting Recorded List', 'Meeting Recorded Lista', 'সভা রেকর্ড তালিকা', 'Meetinge Recorded liste'],
            [9, 'class_recorded_list', 'Class Recorded List', 'Clase Recorded Lista', 'শ্রেণী রেকর্ড তালিকা', 'Classe Recorded liste'],
            [9, 'meeting_recorded_list', 'Meeting Recorded List', 'Meeting Recorded Lista', 'সভা রেকর্ড তালিকা', 'Meetinge Recorded liste'],            
            [0, 'all_sections', 'All Sections', 'ĉiuj sekcioj', 'সমস্ত বিভাগ', 'toutes les sections'], 
            [0,'bulk_print','Bulk Print','Bulk Print','বাল্ক প্রিন্ট','Bulk Print'],
            [0,'bulk','Bulk','Bulk','বাল্ক','Bulk'],
            [0,'per','Per','Per','প্রতি','Per'],
            [0,'part','Part','Part','অংশ','Part'],
            [0,'is_showing','Is Showing','Is Showing','দেখাচছ','Is Showing'],
            [0, 'format_standard_three_character', 'Standard Format 3 Character', 'Standard Format 3 Character', 'স্ট্যান্ডার্ড ফরমেট ৩ ক্যারেক্টার', 'Standard Format 3 Character'],
            [0,'prefix','Prefix','Prefix','প্রারম্ভে স্থাপন করা','Prefix'],
            [18, 'dues_payment', 'Dues Payment', 'Dues Payment', 'বকেয়া অর্থ প্রদান', 'Dues Payment'],
            [19, 'coma', 'Coma', 'Coma', 'কমা', 'Coma']

        ];


        foreach ($d as $row) {
            $s = new SmLanguagePhrase();
            $s->modules = $row[0];
            $s->default_phrases = trim($row[1]);
            $s->en = trim($row[2]);
            $s->es = trim($row[3]);
            $s->bn = trim($row[4]);
            $s->fr = trim($row[5]);
            $s->save();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sm_language_phrases');
    }
}